<?php
/*
  Cron job for broadcast (buttons.json support) - Smart batch size
  Run every 1 minute in cron
*/

error_reporting(0);
require_once '../config.php';
define('API_TOKEN', $token);

// اتصال به دیتابیس
$db = mysqli_connect('localhost', $databaseUser, $databasePass, $databaseName);

// تابع ارسال به API
function BoFile($method, $datas = []) {
    $url = "https://api.telegram.org/bot" . API_TOKEN . "/" . $method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    $res = curl_exec($ch);
    curl_close($ch);
    return @json_decode($res, true);
}

// ensure lib folder for status files
if (!is_dir(__DIR__ . '/lib')) {
    @mkdir(__DIR__ . '/lib', 0775, true);
}

/**
 * Try to load buttons.json (inline keyboard JSON)
 */
function loadButtonsJson(): ?string {
    $paths = [
        __DIR__ . '/../buttons.json',
        __DIR__ . '/buttons.json',
        __DIR__ . '/../../buttons.json'
    ];
    foreach ($paths as $p) {
        if (file_exists($p)) {
            $content = trim(file_get_contents($p));
            if ($content !== '') {
                return $content;
            }
        }
    }
    return null;
}

// load global keyboard JSON if exists
$globalReplyMarkup = loadButtonsJson();

// helper → attach keyboard if exists
function withButton(array $params, ?string $globalReplyMarkup): array {
    if ($globalReplyMarkup) {
        $params['reply_markup'] = $globalReplyMarkup;
    }
    return $params;
}

// گرفتن اطلاعات ارسال
$send = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `send` LIMIT 1"));
if (!empty($send['step'])) {

    $offset  = (int)$send['user'];
    $payload = json_decode($send['text'], true);

    // 🔹 هوشمند سازی batch
    $mediaTypes = ['photo','video','audio','voice','animation','document','sticker','video_note'];
    if ($send['step'] === 'for') {
        $batch = 300; // forward هم رسانه حساب میشه
    } elseif (isset($payload['type']) && $payload['type'] === 'text') {
        $batch = 1000;
    } elseif (isset($payload['type']) && in_array($payload['type'], $mediaTypes)) {
        $batch = 300;
    } else {
        $batch = 500; // پیشفرض
    }

    // گرفتن کاربران
    $usersRes   = mysqli_query($db, "SELECT * FROM `user` LIMIT {$batch} OFFSET {$offset}");
    $usersCount = (int)mysqli_num_rows(mysqli_query($db, "SELECT * FROM `user`"));

    // حالت forward
    if ($send['step'] === 'for') {
        $fromChatId = $send['from'];
        $messageId  = (int)$send['text'];
        while ($row = mysqli_fetch_assoc($usersRes)) {
            BoFile('forwardMessage', [
                'chat_id'      => $row['from_id'],
                'from_chat_id' => $fromChatId,
                'message_id'   => $messageId
            ]);
            $db->query("UPDATE `send` SET `user` = `user` + 1 WHERE 1");
        }

    } else {
        // حالت send → پیام جدید
        if (!is_array($payload)) {
            $db->query("DELETE FROM `send` WHERE 1");
            exit;
        }
        while ($row = mysqli_fetch_assoc($usersRes)) {
            $id = $row['from_id'];
            switch ($payload['type'] ?? '') {
                case 'text':
                    BoFile('sendMessage', withButton([
                        'chat_id' => $id,
                        'text' => $payload['text'] ?? '',
                        'parse_mode' => 'html',
                        'disable_web_page_preview' => true
                    ], $globalReplyMarkup));
                    break;

                case 'photo':
                    BoFile('sendPhoto', withButton([
                        'chat_id' => $id,
                        'photo' => $payload['file_id'],
                        'caption' => $payload['caption'] ?? '',
                        'parse_mode' => 'html'
                    ], $globalReplyMarkup));
                    break;

                case 'video':
                    BoFile('sendVideo', withButton([
                        'chat_id' => $id,
                        'video' => $payload['file_id'],
                        'caption' => $payload['caption'] ?? '',
                        'parse_mode' => 'html'
                    ], $globalReplyMarkup));
                    break;

                case 'audio':
                    BoFile('sendAudio', withButton([
                        'chat_id' => $id,
                        'audio' => $payload['file_id'],
                        'caption' => $payload['caption'] ?? '',
                        'parse_mode' => 'html'
                    ], $globalReplyMarkup));
                    break;

                case 'voice':
                    BoFile('sendVoice', withButton([
                        'chat_id' => $id,
                        'voice' => $payload['file_id'],
                        'caption' => $payload['caption'] ?? '',
                        'parse_mode' => 'html'
                    ], $globalReplyMarkup));
                    break;

                case 'animation':
                    BoFile('sendAnimation', withButton([
                        'chat_id' => $id,
                        'animation' => $payload['file_id'],
                        'caption' => $payload['caption'] ?? '',
                        'parse_mode' => 'html'
                    ], $globalReplyMarkup));
                    break;

                case 'document':
                    BoFile('sendDocument', withButton([
                        'chat_id' => $id,
                        'document' => $payload['file_id'],
                        'caption' => $payload['caption'] ?? '',
                        'parse_mode' => 'html'
                    ], $globalReplyMarkup));
                    break;

                case 'sticker':
                    BoFile('sendSticker', [
                        'chat_id' => $id,
                        'sticker' => $payload['file_id']
                    ]);
                    break;

                case 'video_note':
                    BoFile('sendVideoNote', [
                        'chat_id' => $id,
                        'video_note' => $payload['file_id']
                    ]);
                    break;
            }
            $db->query("UPDATE `send` SET `user` = `user` + 1 WHERE 1");
        }
    }

    // محاسبه پیشرفت
    $progress = (int)(mysqli_fetch_assoc(mysqli_query($db, "SELECT `user` FROM `send` LIMIT 1"))['user'] ?? 0);
    if ($progress > $usersCount) $progress = $usersCount;

    // آپدیت پیام وضعیت (ادمین)
    $statusChatId = @file_get_contents(__DIR__ . '/lib/id.txt');
    $statusMsgId  = @file_get_contents(__DIR__ . '/lib/msg.txt');
    if ($statusChatId && $statusMsgId) {
        BoFile('editMessageReplyMarkup', [
            'chat_id'    => $statusChatId,
            'message_id' => $statusMsgId,
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [ ['text' => "📋 ارسال شده: {$progress}", 'callback_data' => 'none'] ],
                    [ ['text' => "⏳ مانده: " . max(0, round(($usersCount - $progress)/$batch)), 'callback_data' => 'none'] ],
                ]
            ], JSON_UNESCAPED_UNICODE)
        ]);
    }

    // اگر تموم شد
    if ($progress >= $usersCount) {
        BoFile('sendMessage', [
            'chat_id' => $send['from'],
            'text' => "✅ ارسال برای " . number_format($usersCount) . " کاربر کامل شد."
        ]);
        $db->query("DELETE FROM `send` WHERE 1");
    }

} else {
    echo "There is no message to send\n";
}
