<?php
// daily_report.php

require_once __DIR__ . "/config.php";
define('API_TOKEN', $token);

// اتصال به دیتابیس با MySQLi
$db = mysqli_connect('localhost', $databaseUser, $databasePass, $databaseName);
if (!$db) {
    exit("DB connection failed: " . mysqli_connect_error());
}
mysqli_set_charset($db, "utf8mb4");

// گرفتن آیدی owner
$res = mysqli_query($db, "SELECT `type_id` FROM `settings` WHERE `type`='admin' AND `columnOne`='main' LIMIT 1");
$owner = null;
if ($res && $row = mysqli_fetch_assoc($res)) {
    $owner = $row['type_id'];
}
if (!$owner) exit;

// گرفتن یوزرها با تعامل (فقط صفحه ۱)
$page   = 1;
$limit  = 10;
$offset = 0;

$stmt = mysqli_prepare($db, "
    SELECT from_id, username, commands_count
    FROM `user`
    WHERE commands_count > 0
    ORDER BY commands_count DESC
    LIMIT ? OFFSET ?
");
mysqli_stmt_bind_param($stmt, "ii", $limit, $offset);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$users = [];
while ($row = mysqli_fetch_assoc($result)) {
    $users[] = $row;
}

// ساخت گزارش
$report = "📊 گزارش روزانه ربات (صفحه {$page})\n\n";
foreach ($users as $row) {
    $username = !empty($row['username']) ? '@'.$row['username'] : $row['from_id'];
    $report .= "▫️ {$username} → {$row['commands_count']} دستور\n";
}

// تعداد کل کاربران با تعامل
$res_total = mysqli_query($db, "SELECT COUNT(*) AS total FROM `user` WHERE commands_count > 0");
$total_users = 0;
if ($res_total && $row = mysqli_fetch_assoc($res_total)) {
    $total_users = $row['total'];
}
$total_pages = ceil($total_users / $limit);

// ساخت دکمه‌ها
$keyboard = ["inline_keyboard" => []];
if ($total_pages > 1) {
    $keyboard["inline_keyboard"][0][] = ["text" => "بعدی ▶️", "callback_data" => "report_page_2"];
}
// دکمه بستن
$keyboard["inline_keyboard"][] = [
    ["text" => "❌ بستن", "callback_data" => "report_close"]
];

// تابع ارسال پیام (همون سبک delete_file.php)
function sendMessage($chat_id, $text, $reply_markup = null) {
    $url = "https://api.telegram.org/bot" . API_TOKEN . "/sendMessage";
    $post = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => "html",
        'disable_web_page_preview' => true
    ];
    if ($reply_markup) {
        $post['reply_markup'] = json_encode($reply_markup, JSON_UNESCAPED_UNICODE);
    }
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}

// ارسال گزارش به owner
sendMessage($owner, $report, $keyboard);
