<?php
// daily_report.php

require __DIR__ . "/config.php";

// اتصال به دیتابیس با PDO
try {
    $db = new PDO("mysql:host=localhost;dbname={$databaseName};charset=utf8mb4", $databaseUser, $databasePass);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    exit;
}

// گرفتن آیدی owner
$stmt = $db->query("SELECT `type_id` FROM `settings` WHERE `type`='admin' AND `columnOne`='main' LIMIT 1");
$owner = $stmt->fetchColumn();
if (!$owner) exit;

// گرفتن یوزرها با تعامل
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$limit = 10;
$offset = ($page - 1) * $limit;

$stmt = $db->prepare("
    SELECT from_id, username, commands_count
    FROM `user`
    WHERE commands_count > 0
    ORDER BY commands_count DESC
    LIMIT :limit OFFSET :offset
");
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);

// ساخت گزارش
$report = "📊 گزارش روزانه ربات (صفحه {$page})\n\n";
foreach ($users as $row) {
    $username = !empty($row['username']) ? '@'.$row['username'] : $row['from_id'];
    $report .= "▫️ {$username} → {$row['commands_count']} دستور\n";
}

// تعداد کل کاربران با تعامل
$total_stmt = $db->query("SELECT COUNT(*) FROM `user` WHERE commands_count > 0");
$total_users = $total_stmt->fetchColumn();
$total_pages = ceil($total_users / $limit);

// ساخت دکمه‌های صفحه‌بندی
$keyboard = ["inline_keyboard" => []];
if ($page > 1) {
    $keyboard["inline_keyboard"][0][] = ["text" => "◀️ قبلی", "callback_data" => "report_page_" . ($page - 1)];
}
if ($page < $total_pages) {
    $keyboard["inline_keyboard"][0][] = ["text" => "بعدی ▶️", "callback_data" => "report_page_" . ($page + 1)];
}

// تابع ارسال پیام
function sendMessage($chat_id, $text, $token, $reply_markup = null) {
    $url = "https://api.telegram.org/bot{$token}/sendMessage";
    $post = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => "html",
    ];
    if ($reply_markup) {
        $post['reply_markup'] = json_encode($reply_markup);
    }
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}

// ارسال گزارش به owner
sendMessage($owner, $report, $token, $keyboard);

// ریست شمارنده (بعد از گزارش نهایی)
// ❗ می‌تونی بخوای فقط بعد از ارسال صفحه ۱ ریست بشه
if ($page == 1) {
    $db->query("UPDATE `user` SET commands_count = 0");
}
