<?php
// بارگذاری تنظیمات
require_once __DIR__ . '/config.php';
define('API_TOKEN', $token);

// اتصال به دیتابیس با MySQLi
$db = mysqli_connect('localhost', $databaseUser, $databasePass, $databaseName);
if (!$db) {
    exit("DB connection failed: " . mysqli_connect_error());
}
mysqli_set_charset($db, "utf8mb4");

// تابع ارسال پیام
function sendMessage($chat_id, $text, $keyboard = null) {
    $url = "https://api.telegram.org/bot" . API_TOKEN . "/sendMessage";
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    if ($keyboard) {
        $data['reply_markup'] = $keyboard;
    }
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_exec($ch);
    curl_close($ch);
}

// تابع گرفتن وضعیت اشتراک
function getSubscriptionStatus($db) {
    $res = mysqli_query($db, "SELECT columnOne FROM settings WHERE type='subscription_status' LIMIT 1");
    $row = $res ? mysqli_fetch_assoc($res) : null;
    return $row ? $row['columnOne'] : 'on'; // پیش‌فرض روشن
}

// کیبورد کاربران بدون اشتراک (بسته به وضعیت روشن/خاموش)
function getNoSubKeyboard($db) {
    $status = getSubscriptionStatus($db);
    if ($status === 'off') {
        // وقتی اشتراک خاموشه → فقط پشتیبانی
        return json_encode([
            'keyboard' => [
                [['text' => "☎️ پشتیبانی کانال ایران بالیوود"], ['text' => "🤖 پشتیبانی ربات"]],
            ],
            'resize_keyboard' => true
        ], JSON_UNESCAPED_UNICODE);
    } else {
        // وقتی اشتراک روشنه → دکمه خرید + پشتیبانی
        return json_encode([
            'keyboard' => [
                [['text' => "💳 خرید اشتراک"]],
                [['text' => "🎁 خرید اشتراک هدیه برای دیگران"]],
                [['text' => "☎️ پشتیبانی کانال ایران بالیوود"], ['text' => "🤖 پشتیبانی ربات"]],
            ],
            'resize_keyboard' => true
        ], JSON_UNESCAPED_UNICODE);
    }
}

$subscription_status = getSubscriptionStatus($db);
$now = time();

// گرفتن لیست کاربران دارای اشتراک
$res = mysqli_query($db, "
    SELECT user_id, end_date 
    FROM subscriptions 
    WHERE approved = 1
");

while ($row = mysqli_fetch_assoc($res)) {
    $end_time = strtotime($row['end_date']);
    $minutes_left = ($end_time - $now) / 60;

    // 🔹 اگر اشتراک روشن بود → هشدار کمتر از 1 روز
    if ($subscription_status === 'on' && $minutes_left > 0 && $minutes_left <= 1440) {
        $stmt = mysqli_prepare($db, "SELECT 1 FROM warn_logs WHERE user_id = ? AND warn_type = 'less_1day'");
        mysqli_stmt_bind_param($stmt, "i", $row['user_id']);
        mysqli_stmt_execute($stmt);
        $res_check = mysqli_stmt_get_result($stmt);

        if (!mysqli_fetch_assoc($res_check)) {
            sendMessage(
                $row['user_id'],
                "⏳ کاربر گرامی، اشتراک شما کمتر از یک روز دیگر به پایان می‌رسد!\nدر صورت تمایل می‌توانید از منوی زیر اشتراک خود را تمدید کنید."
            );
            $stmt_insert = mysqli_prepare($db, "INSERT INTO warn_logs (user_id, warn_type, warn_time) VALUES (?, 'less_1day', NOW())");
            mysqli_stmt_bind_param($stmt_insert, "i", $row['user_id']);
            mysqli_stmt_execute($stmt_insert);
        }
    }

    // 🔹 پایان اشتراک → همیشه باید انجام شود
    if ($minutes_left <= 0) {
        $keyboard = getNoSubKeyboard($db);

        if ($subscription_status === 'on') {
            // وقتی اشتراک روشن است
            $end_msg = "❌ اشتراک شما به پایان رسید.\nهمیشه به راحتی می‌توانید از منوی پایین اشتراک تهیه کنید.";
        } else {
            // وقتی اشتراک خاموش است
            $end_msg = "❌ اشتراک شما به پایان رسید.";
        }

        sendMessage($row['user_id'], $end_msg, $keyboard);

        // حذف همه هشدارهای این کاربر
        $stmt_del1 = mysqli_prepare($db, "DELETE FROM warn_logs WHERE user_id = ?");
        mysqli_stmt_bind_param($stmt_del1, "i", $row['user_id']);
        mysqli_stmt_execute($stmt_del1);

        // حذف اشتراک از جدول subscriptions
        $stmt_del2 = mysqli_prepare($db, "DELETE FROM subscriptions WHERE user_id = ?");
        mysqli_stmt_bind_param($stmt_del2, "i", $row['user_id']);
        mysqli_stmt_execute($stmt_del2);
    }
}
