<?php
// backup_database.php
require_once __DIR__ . "/config.php";
require_once __DIR__ . '/jdf.php';
define('API_TOKEN', $token);
date_default_timezone_set('Asia/Tehran');

// اتصال به دیتابیس
$db = mysqli_connect('localhost', $databaseUser, $databasePass, $databaseName);
if (!$db) exit("DB connection failed: " . mysqli_connect_error());
mysqli_set_charset($db, "utf8mb4");

// گرفتن آیدی مالک (owner)
$res = mysqli_query($db, "SELECT `type_id` FROM `settings` WHERE `type`='admin' AND `columnOne`='main' LIMIT 1");
$owner = $res && ($row = mysqli_fetch_assoc($res)) ? $row['type_id'] : null;
if (!$owner) exit;

// مسیر و نام فایل بکاپ
$backupDir = __DIR__ . '/backups/';
if (!is_dir($backupDir) && !mkdir($backupDir, 0755, true)) {
    sendMessage($owner, "❌ خطا در ساخت پوشه بکاپ!");
    exit;
}

// حذف بکاپ‌های قدیمی‌تر از 7 روز
foreach (glob($backupDir . 'backup_*.sql.gz') as $oldBackup) {
    if (filemtime($oldBackup) < time() - 7 * 24 * 60 * 60) {
        unlink($oldBackup);
    }
}

$backupFile = $backupDir . 'backup_' . $databaseName . '_' . date('Y-m-d_H-i-s') . '.sql';

// ساخت بکاپ با mysqldump (با ایمنی بالا)
$command = sprintf(
    'mysqldump --user=%s --password=%s --host=localhost %s > %s',
    escapeshellarg($databaseUser),
    escapeshellarg($databasePass),
    escapeshellarg($databaseName),
    escapeshellarg($backupFile)
);

exec($command, $output, $return_var);

// بررسی موفقیت بکاپ
if ($return_var !== 0 || !file_exists($backupFile)) {
    sendMessage($owner, "❌ خطا در ایجاد بکاپ دیتابیس!");
    exit;
}

// بررسی وجود gzip
if (!`which gzip`) {
    sendMessage($owner, "❌ ابزار gzip روی سرور نصب نیست!");
    unlink($backupFile);
    exit;
}

// فشرده‌سازی فایل بکاپ
$backupFileGz = $backupFile . '.gz';
$gzipCmd = sprintf('gzip -9 -c %s > %s', escapeshellarg($backupFile), escapeshellarg($backupFileGz));
exec($gzipCmd, $output, $gzip_ret);
if ($gzip_ret !== 0 || !file_exists($backupFileGz)) {
    sendMessage($owner, "❌ خطا در فشرده‌سازی فایل بکاپ!");
    unlink($backupFile);
    exit;
}
unlink($backupFile); // حذف نسخه غیر فشرده

// بررسی حجم فایل (محدودیت 50MB تلگرام)
$fileSize = round(filesize($backupFileGz) / 1024 / 1024, 2);
if ($fileSize > 50) {
    sendMessage($owner, "⚠️ فایل بکاپ ({$fileSize} MB) بزرگ‌تر از حد مجاز تلگرام (50 MB) است و ارسال نشد!");
    unlink($backupFileGz);
    exit;
}

// تابع ارسال پیام
function sendMessage($chat_id, $text, $reply_markup = null) {
    $url = "https://api.telegram.org/bot" . API_TOKEN . "/sendMessage";
    $post = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => "html",
        'disable_web_page_preview' => true
    ];
    if ($reply_markup) {
        $post['reply_markup'] = json_encode($reply_markup, JSON_UNESCAPED_UNICODE);
    }
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $post,
        CURLOPT_RETURNTRANSFER => true
    ]);
    $result = curl_exec($ch);
    if ($result === false) {
        error_log("cURL error in sendMessage: " . curl_error($ch));
        curl_close($ch);
        return false;
    }
    curl_close($ch);
    return $result;
}

// تابع ارسال فایل
function sendDocument($chat_id, $file_path, $caption = '') {
    $url = "https://api.telegram.org/bot" . API_TOKEN . "/sendDocument";
    $post = [
        'chat_id' => $chat_id,
        'caption' => $caption,
        'document' => new CURLFile($file_path),
        'parse_mode' => 'HTML' // 👈 اضافه شد
    ];
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $post,
        CURLOPT_RETURNTRANSFER => true
    ]);
    $result = curl_exec($ch);
    if ($result === false) {
        error_log("cURL error in sendDocument: " . curl_error($ch));
        curl_close($ch);
        return false;
    }
    curl_close($ch);
    return $result;
}


// ارسال پیام موفقیت و فایل
sendMessage($owner, "📦 بکاپ دیتابیس با موفقیت ایجاد و فشرده شد!\n🕒 " . jdate('Y/m/d | H:i') . "\n💾 حجم: {$fileSize} MB");

$response = sendDocument($owner, $backupFileGz, "📁 فایل بکاپ دیتابیس: <b>{$databaseName}</b>\n🕒 تاریخ: " . jdate('j F Y - H:i'));
$json = json_decode($response, true);

if ($json && isset($json['ok']) && $json['ok']) {
    unlink($backupFileGz);
} else {
    sendMessage($owner, "⚠️ ارسال فایل بکاپ ناموفق بود! فایل در سرور باقی ماند: \n<code>" . basename($backupFileGz) . "</code>");
}
?>