<?php
require_once __DIR__ . '/init.php';
#======================= کیبورد منوی اشتراک =======================#
$subscription_menu = json_encode([
    'keyboard' => [
        [['text' => "🗑 حذف اشتراک"], ['text' => "💳 ایجاد اشتراک"]],
        [['text' => "💳 کارت واریز"], ['text' => "📋 پلن‌های اشتراک"]],
        [['text' => "🎟 کد تخفیف"], ['text' => "🟢 اشتراک‌های فعال"]],
        [['text' => "برگشت 🔙"]]
    ],
    'resize_keyboard' => true
], JSON_UNESCAPED_UNICODE);
#======================= کیبورد برگشت به منوی اشتراک =======================#
if ($text == "🔙 برگشت" && $from_id == $is_admin) {
    $db->query("UPDATE user SET step = 'none', temp_user_id = NULL WHERE from_id = '$from_id'");
    sendMessage($from_id, "به منوی اشتراک برگشتید.", "html", $subscription_menu, $message_id);
}
#======================= منوی اشتراک ادمین =======================#
elseif ($text == "🎫 اشتراک" && $from_id == $is_admin) {
    $db->query("UPDATE user SET step = 'none', temp_user_id = NULL WHERE from_id = '$from_id'");
    sendMessage($from_id, "لطفاً یکی از گزینه‌ها را انتخاب کنید:", "html", $subscription_menu, $message_id);
}
#======================= تصحیح منوی اشتراک =======================#
elseif ($text == "💳 ایجاد اشتراک" && $from_id == $is_admin) {
    $db->query("UPDATE user SET step = 'enter_user_id_create', temp_user_id = NULL WHERE from_id = '$from_id'");
    sendMessage($from_id, "🎫 برای ایجاد اشتراک لطفاً یوزرنیم یا آیدی عددی  کاربر را وارد کنید یا یک پیام از او فوروارد کنید.\nمثال:\n@username\nیا:\nusername\nیا:\nآیدی عددی", "html", $back_panel, $message_id);
}
elseif ($text == "🗑 حذف اشتراک" && $from_id == $is_admin) {
    $current_time = date('Y-m-d H:i:s');
    $subs_count = mysqli_num_rows($db->query("SELECT id FROM subscriptions WHERE approved = 1 AND end_date > '$current_time'"));
    if ($subs_count == 0) {
        sendMessage($from_id, "❌ در حال حاضر هیچ اشتراک فعالی وجود ندارد.", "html", $back_panel, $message_id);
        return;
    }
    $db->query("UPDATE user SET step = 'enter_user_id_delete', temp_user_id = NULL WHERE from_id = '$from_id'");
    sendMessage($from_id, "🗑برای حذف اشتراک لطفاً یوزرنیم یا آیدی عددی  کاربر را وارد کنید یا یک پیام از او فوروارد کنید.\nمثال:\n@username\nیا:\nusername\nیا:\nآیدی عددی\n⚠️دقت کنید که اشتراک کاربر کاملا حذف میشود!", "html", $back_panel, $message_id);
}
elseif ($text == "📋 پلن‌های اشتراک" && $from_id == $is_admin) {
    $db->query("UPDATE user SET step = 'none', temp_user_id = NULL WHERE from_id = '$from_id'");
    $plans_menu = json_encode([
        'keyboard' => [
            [['text' => "🗑 حذف پلن"], ['text' => "➕ ایجاد پلن"]],
            [['text' => "📜 مشاهده پلن‌ها"]],
            [['text' => "🔙 برگشت"]]
        ], 'resize_keyboard' => true
    ], JSON_UNESCAPED_UNICODE);
    sendMessage($from_id, "لطفاً یکی از گزینه‌های پلن‌های اشتراک را انتخاب کنید:", "html", $plans_menu, $message_id);
}
elseif ($text == "💳 کارت واریز" && $from_id == $is_admin) {
    $keyboard = json_encode([
        'keyboard' => [
            [['text' => "✏️ تغییر مشخصات کارت"], ['text' => "📇 مشخصات کارت"]],
            [['text' => "🔙 برگشت"]],
        ], 'resize_keyboard' => true
    ], JSON_UNESCAPED_UNICODE);
    sendMessage($from_id, "لطفاً یکی از گزینه‌ها را انتخاب کنید:", "html", $keyboard, $message_id);
}
elseif ($text == "🟢 اشتراک‌های فعال" && $from_id == $is_admin) {
    $page = 1;
    $per_page = 5;
    $offset = 0;
    $current_time = date('Y-m-d H:i:s');
    $subscriptions = $db->query("
        SELECT s.*, u.username 
        FROM subscriptions s 
        LEFT JOIN user u ON s.user_id = u.from_id 
        WHERE s.approved = 1 AND s.end_date > '$current_time' 
        ORDER BY s.end_date ASC 
        LIMIT $per_page OFFSET $offset
    ");
    $total_subscriptions = mysqli_num_rows($db->query("
        SELECT * FROM subscriptions 
        WHERE approved = 1 AND end_date > '$current_time'
    "));
    if (mysqli_num_rows($subscriptions) > 0) {
        $message = "📋 لیست اشتراک‌های فعال (صفحه $page):\n\n";
        while ($sub = mysqli_fetch_assoc($subscriptions)) {
            $user_id = $sub['user_id'];
            $username = $sub['username'] ? "@" . $sub['username'] : "نامشخص";
            $end_date = $sub['end_date'];
            $days_left = max(0, ceil((strtotime($end_date) - strtotime($current_time)) / 86400));
            $message .= "🌀 آیدی عددی : <code>$user_id</code>\n";
            $message .= "یوزرنیم :\n$username\n";
            $message .= "📅 روزهای باقی‌مانده: $days_left روز\n";
            $message .= "⏰ انقضا: " . jdate('Y/m/d H:i:s', strtotime($end_date)) . "\n";
            $message .= "──────────────────\n";
        }
        $inline_keyboard = [];
        if ($page > 1) {
            $inline_keyboard[] = [['text' => "صفحه قبل", 'callback_data' => "active_subs_page_" . ($page - 1)]];
        }
        if ($per_page < $total_subscriptions) {
            $inline_keyboard[] = [['text' => "صفحه بعد", 'callback_data' => "active_subs_page_" . ($page + 1)]];
        }
        $keyboard = json_encode(['inline_keyboard' => $inline_keyboard], JSON_UNESCAPED_UNICODE);
        sendMessage($from_id, $message, "html", $keyboard, $message_id);
    } else {
        sendMessage($from_id, "هیچ اشتراک فعالی وجود ندارد.", "html", $subscription_menu, $message_id);
    }
}
elseif ($text == "🎟 کد تخفیف" && $from_id == $is_admin) {
    $db->query("UPDATE user SET step = 'none', temp_user_id = NULL WHERE from_id = '$from_id'");
    $discount_menu = json_encode([
        'keyboard' => [
            [['text' => "🗑 حذف کد تخفیف"], ['text' => "➕ ایجاد کد تخفیف"]],
            [['text' => "📜 کدهای تخفیف فعال"]],
            [['text' => "🔙 برگشت"]]
        ], 'resize_keyboard' => true
    ], JSON_UNESCAPED_UNICODE);
    sendMessage($from_id, "لطفاً یکی از گزینه‌های کد تخفیف را انتخاب کنید:", "html", $discount_menu, $message_id);
}
#======================= کدهای ایجاد اشتراک =======================#
elseif ($step == 'enter_user_id_create' && $from_id == $is_admin) {
    $target_user_id = null;
    if (isset($update->message->forward_from)) {
        $target_user_id = $update->message->forward_from->id;
    } elseif (isset($update->message->forward_sender_name)) {
        sendMessage($from_id, "⚠️ این کاربر پرایوسی فروارد فعال دارد و آیدی عددی‌اش مشخص نیست. لطفاً آیدی عددی یا یوزرنیم را به صورت دستی وارد کنید.", "html", $back_panel, $message_id);
        return;
    } elseif (preg_match('/^\d+$/', fa_to_en_numbers($text))) {
        $target_user_id = fa_to_en_numbers($text);
    } elseif (preg_match('/^@?(\w+)$/', $text, $matches)) {
        $username_input = $matches[1];
        $user_check = $db->query("SELECT from_id FROM user WHERE username = '$username_input' LIMIT 1");
        if ($user_check && mysqli_num_rows($user_check) > 0) {
            $user_data = mysqli_fetch_assoc($user_check);
            $target_user_id = $user_data['from_id'];
        } else {
            sendMessage($from_id, "❌ یوزرنیم وارد شده یافت نشد یا کاربر هنوز با ربات تعامل نداشته است. لطفاً آیدی عددی معتبر وارد کنید یا پیام فوروارد کنید:", "html", $back_panel, $message_id);
            return;
        }
    } else {
        sendMessage($from_id, "❌ لطفاً آیدی عددی معتبر یا یوزرنیم (مثلاً @username) وارد کنید یا پیام فوروارد کنید:", "html", $back_panel, $message_id);
        return;
    }
    if (in_array($target_user_id, $admins)) {
        sendMessage(
            $from_id,
            "⚠️ کاربر انتخاب‌شده ادمین است و نیازی به دریافت اشتراک ندارد.",
            "html",
            $back_panel,
            $message_id
        );
        $db->query("UPDATE user SET step = 'none' WHERE from_id = '$from_id'");
        return;
    }
    $user_check = $db->query("SELECT * FROM user WHERE from_id = '$target_user_id'");
    if (mysqli_num_rows($user_check) > 0) {
        $db->query("UPDATE user SET step = 'enter_minutes', temp_user_id = '$target_user_id' WHERE from_id = '$from_id'");
        sendMessage($from_id, "لطفاً تعداد روزهای اشتراک را به‌صورت عددی وارد کنید:", "html", $back_panel, $message_id);
    } else {
        sendMessage($from_id, "❌ کاربر با این آیدی وجود ندارد. لطفاً آیدی معتبر وارد کنید یا پیام فوروارد کنید:", "html", $back_panel, $message_id);
    }
}
elseif ($step == 'enter_minutes' && $from_id == $is_admin) {
    $input_number = fa_to_en_numbers(trim($text));
    if (is_numeric($input_number)) {
        $target_user_id = mysqli_fetch_assoc(
            $db->query("SELECT temp_user_id FROM user WHERE from_id = '$from_id'")
        )['temp_user_id'];
        $current_time = date('Y-m-d H:i:s');
        $days = 0; 
        $hours = 0; 
        $minutes = 0;
        $plan_minutes = 0;
        $response_text = "";
        if ($input_number >= 1) {
            $days = (int)$input_number;
            $plan_minutes = $days * 24 * 60;
            $response_text = "$days روز";
        } else {
            $input_str = strval($input_number);
            if (strpos($input_str, '0.0') === 0) {
                $decimal = substr($input_str, 2);
                $minutes = intval(ltrim($decimal, '0'));
                if ($minutes <= 0) {
                    sendMessage($from_id, "❌ مقدار وارد شده باید بیشتر از صفر باشد.", "html", $back_panel, $message_id);
                    return;
                }
                $plan_minutes = $minutes;
                $response_text = "$minutes دقیقه";
            } elseif (strpos($input_str, '0.') === 0) {
                $decimal = substr($input_str, 2);
                $hours = intval(ltrim($decimal, '0'));
                if ($hours <= 0) {
                    sendMessage($from_id, "❌ مقدار وارد شده باید بیشتر از صفر باشد.", "html", $back_panel, $message_id);
                    return;
                }
                $plan_minutes = $hours * 60;
                $response_text = "$hours ساعت";
            } else {
                sendMessage($from_id, "❌ فرمت عدد وارد شده نامعتبر است.", "html", $back_panel, $message_id);
                return;
            }
        }
        $existing_subscription = $db->query("SELECT * FROM subscriptions WHERE user_id = '$target_user_id' AND approved = 1 AND end_date > '$current_time'");
        if (mysqli_num_rows($existing_subscription) > 0) {
            $subscription = mysqli_fetch_assoc($existing_subscription);
            $current_end_date = $subscription['end_date'];
            $new_end_date = date('Y-m-d H:i:s', strtotime("$current_end_date + $plan_minutes minutes"));
            $db->query("UPDATE subscriptions SET end_date = '$new_end_date', created_at = '$current_time', plan_minutes = '$plan_minutes' WHERE user_id = '$target_user_id' AND approved = 1");
        } else {
            $start_date = date('Y-m-d H:i:s');
            $new_end_date = date('Y-m-d H:i:s', strtotime("+$plan_minutes minutes"));
            $db->query("INSERT INTO subscriptions (user_id, plan_minutes, start_date, end_date, approved) VALUES ('$target_user_id', '$plan_minutes', '$start_date', '$new_end_date', 1)");
        }
        $new_end_date_jalali = jdate('Y/m/d H:i:s', strtotime($new_end_date));
        $response_text_fa = en_to_fa_numbers($response_text);
        $new_end_date_fa = en_to_fa_numbers($new_end_date_jalali);
        $trow = mysqli_fetch_assoc(
        $db->query("SELECT username FROM `user` WHERE from_id = '$target_user_id' LIMIT 1")
    );
        $target_username = !empty($trow['username']) ? "@".$trow['username'] : en_to_fa_numbers($target_user_id);
    
    // حالا با تابع کمکی نمایش بساز
        $target_display = getDisplayName($target_username, $target_user_id);            
        sendMessage(
            $from_id,
            "✅ ایجاد اشتراک جدید برای کاربر\n\n".
            "👥 کاربر: $target_display\n".
            "🎫 مدت: $response_text_fa\n".
            "⏳ تاریخ انقضا: $new_end_date_fa",
            "html",
            $panel,
            $message_id
        );
        sendMessage(
            $target_user_id,
            "✅ اشتراک شما با موفقیت ایجاد شد\n\n".
            "🎫 مدت: $response_text_fa\n".
            "⏳ تاریخ انقضا: $new_end_date_fa",
            "html",
            getUserKeyboard($db, $target_user_id)
        );

        // اگر ادمین اصلی نیست، اطلاع‌رسانی به ادمین اصلی
        if ($from_id != $admin) {
            // گرفتن یوزرنیم ادمین و کاربر
            $admin_username_query = $db->query("SELECT username FROM `user` WHERE `from_id` = '$from_id' LIMIT 1");
            $admin_username = mysqli_fetch_assoc($admin_username_query)['username'] ?? 'نامشخص';
            $user_username_query = $db->query("SELECT username FROM `user` WHERE `from_id` = '$target_user_id' LIMIT 1");
            $user_username = mysqli_fetch_assoc($user_username_query)['username'] ?? 'نامشخص';

            // اطلاع‌رسانی به ادمین اصلی
            sendMessage(
                $admin,
                "✅ ایجاد اشتراک جدید\n\n".
                "👤 ادمین: @$admin_username\n".
                "👥 کاربر: @$user_username\n".
                "📅 مدت: $response_text_fa\n".
                "⏳ تا: $new_end_date_fa\n".
                "🕒 زمان ثبت: ".jdate('Y/m/d H:i:s', strtotime('now')),
                "html"
            );
        }

        $db->query("UPDATE user SET step = 'none', temp_user_id = NULL WHERE from_id = '$from_id'");
    } else {
        sendMessage($from_id, "❌ لطفاً تعداد روزهای اشتراک را به‌صورت عددی وارد کنید:", "html", $back_panel, $message_id);
    }
}
#======================= کدهای حذف اشتراک =======================#
elseif ($step == 'enter_user_id_delete' && $from_id == $is_admin) {
    $target_user_id = null;
    if (isset($update->message->forward_from)) {
        $target_user_id = $update->message->forward_from->id;
    } elseif (isset($update->message->forward_sender_name)) {
        sendMessage($from_id, "⚠️ این کاربر پرایوسی فروارد فعال دارد و آیدی عددی‌اش مشخص نیست. لطفاً آیدی عددی یا یوزرنیم را به صورت دستی وارد کنید.", "html", $back_panel, $message_id);
        return;
    } elseif (preg_match('/^\d+$/', fa_to_en_numbers($text))) {
        $target_user_id = fa_to_en_numbers($text);
    } elseif (preg_match('/^@?(\w+)$/', $text, $matches)) {
        $username_input = $matches[1];
        $user_check = $db->query("SELECT from_id FROM user WHERE username = '$username_input' LIMIT 1");
        if ($user_check && mysqli_num_rows($user_check) > 0) {
            $user_data = mysqli_fetch_assoc($user_check);
            $target_user_id = $user_data['from_id'];
        } else {
            sendMessage($from_id, "❌ یوزرنیم وارد شده یافت نشد یا کاربر هنوز با ربات تعامل نداشته است. لطفاً آیدی عددی معتبر وارد کنید یا پیام فوروارد کنید:", "html", $back_panel, $message_id);
            return;
        }
    } else {
        sendMessage($from_id, "❌ لطفاً آیدی عددی معتبر یا یوزرنیم (مثلاً @username) وارد کنید یا پیام فوروارد کنید:", "html", $back_panel, $message_id);
        return;
    }
    $current_time = date('Y-m-d H:i:s');
    $subscription = $db->query("SELECT * FROM subscriptions WHERE user_id = '$target_user_id' AND approved = 1 AND end_date > '$current_time'");
    if (mysqli_num_rows($subscription) > 0) {
        $db->query("DELETE FROM subscriptions WHERE user_id = '$target_user_id' AND approved = 1");
    // فرض کن $target_username و $target_user_id رو قبلاً داری
    // بعد از اینکه $target_user_id رو به‌دست آوردی:
    $trow = mysqli_fetch_assoc(
        $db->query("SELECT username FROM `user` WHERE from_id = '$target_user_id' LIMIT 1")
    );
        $target_username = !empty($trow['username']) ? "@".$trow['username'] : en_to_fa_numbers($target_user_id);
    
    // حالا با تابع کمکی نمایش بساز
    $target_display = getDisplayName($target_username, $target_user_id);
    
    // پیام به ادمین
    sendMessage(
        $from_id,
        "🗑 حذف اشتراک\n\n".
        "👥 کاربر: $target_display\n".
        "✅ اشتراک وی با موفقیت حذف شد.",
        "html",
        $back_panel,
        $message_id
    );



// پیام به کاربر هدف
sendMessage(
    $target_user_id,
    "❌ اشتراک شما توسط ادمین حذف شد.",
    "html",
    getUserKeyboard($db, $target_user_id)
);


        // اگر ادمین اصلی نیست، اطلاع‌رسانی به ادمین اصلی
        if ($from_id != $admin) {
            // گرفتن یوزرنیم ادمین و کاربر
            $admin_username_query = $db->query("SELECT username FROM `user` WHERE `from_id` = '$from_id' LIMIT 1");
            $admin_username = mysqli_fetch_assoc($admin_username_query)['username'] ?? 'نامشخص';
            $user_username_query = $db->query("SELECT username FROM `user` WHERE `from_id` = '$target_user_id' LIMIT 1");
            $user_username = mysqli_fetch_assoc($user_username_query)['username'] ?? 'نامشخص';

            // اطلاع‌رسانی به ادمین اصلی
            sendMessage(
                $admin,
                "⚠️ حذف اشتراک\n\n".
                "👤 ادمین: @$admin_username\n".
                "👥 کاربر: @$user_username\n".
                "🕒 زمان حذف: ".jdate('Y/m/d H:i:s', strtotime('now')),
                "html"
            );
        }

        $db->query("UPDATE user SET step = 'none', temp_user_id = NULL WHERE from_id = '$from_id'");
        $db->query("UPDATE user SET step = 'none' WHERE from_id = '$target_user_id'");
    } else {
        sendMessage($from_id, "❌ اشتراک فعالی برای این کاربر وجود ندارد.", "html", $back_panel, $message_id);
    }
}
#======================= کدهای پلن‌های اشتراک =======================#
elseif ($text == "➕ ایجاد پلن" && $from_id == $is_admin) {
    $db->query("UPDATE user SET step = 'create_plan', temp_user_id = NULL WHERE from_id = '$from_id'");
    sendMessage($from_id, "لطفاً پلن خود را تعریف کنید (برای سهولت کاربران، بهتر است تعداد روز یا ماه به همراه قیمت در متن درج شود):", "html", $back_panel, $message_id);
}
elseif ($text == "🗑 حذف پلن" && $from_id == $is_admin) {
    $db->query("UPDATE user SET step = 'delete_plan', temp_user_id = NULL WHERE from_id = '$from_id'");
    sendMessage($from_id, "لطفاً متن دقیق پلن (مثلاً 'اشتراک 10 روزه - 10000 تومن') را وارد کنید.\nاز گزینه مشاهده پلن‌ها هم میتوانید برای کپی کردن نام دقیق پلن‌ها استفاده کنید.", "html", $back_panel, $message_id);
}
elseif ($text == "📜 مشاهده پلن‌ها" && $from_id == $is_admin) {
    $plans = $db->query("SELECT * FROM subscription_plans ORDER BY days ASC");
    if (mysqli_num_rows($plans) > 0) {
        $message = "📜 لیست پلن‌های اشتراک:\n\n";
        while ($plan = mysqli_fetch_assoc($plans)) {
            $plan_name = $plan['plan_name'];
            $days = $plan['days'];
            $price = number_format($plan['price']) . " تومن";
            $created_at = jdate('Y/m/d H:i:s', strtotime($plan['created_at']));
            $message .= "📅 پلن: <code>$plan_name</code>\n";
            $message .= "⏳ مدت: $days روز\n";
            $message .= "💰 قیمت: $price\n";
            $message .= "📅 تاریخ ایجاد: $created_at\n";
            $message .= "──────────────────\n";
        }
        sendMessage($from_id, $message, "html", null, $message_id);
    } else {
        sendMessage($from_id, "هیچ پلن اشتراکی تعریف نشده است.", "html", null, $message_id);
    }
}
#======================= کدهای ایجاد پلن =======================#
elseif ($step == 'create_plan' && $from_id == $is_admin) {
    $text = fa_to_en_numbers(trim($text));
    $plan_name = $text;
    $current_time = date('Y-m-d H:i:s');
    $days = 0;
    $hours = 0;
    $minutes = 0;
    $price = 0;
    if (preg_match('/(\d+)\s*(روز(?:ه|ی)?)/u', $text, $matches)) {
        $days = (int)$matches[1];
    } elseif (preg_match('/(\d+)\s*(ماه(?:ه|ی)?)/u', $text, $matches)) {
        $days = (int)$matches[1] * 30;
    } elseif (preg_match('/(\d+)\s*(ساعت(?:ه|ی)?)/u', $text, $matches)) {
        $hours = (int)$matches[1];
    } elseif (preg_match('/(\d+)\s*(دقیقه(?:ای)?)/u', $text, $matches)) {
        $minutes = (int)$matches[1];
    }
    if (preg_match('/(\d+)\s*(?:تومن|تومان)/u', $text, $matches)) {
        $price = (int)$matches[1];
    }
    if (($days > 0 || $hours > 0 || $minutes > 0) && $price > 0) {
        $db->query("INSERT INTO subscription_plans (plan_name, days, hours, minutes, price, created_at, created_by) 
                    VALUES ('$plan_name', '$days', '$hours', '$minutes', '$price', '$current_time', '$from_id')");
        sendMessage(
            $from_id,
            en_to_fa_numbers("✅ پلن '$plan_name' با موفقیت درج شد."),
            "html",
            $plans_menu,
            $message_id
        );

        // اگر ادمین اصلی نیست، اطلاع‌رسانی به ادمین اصلی
        if ($from_id != $admin) {
            // گرفتن یوزرنیم ادمین
            $admin_username_query = $db->query("SELECT username FROM `user` WHERE `from_id` = '$from_id' LIMIT 1");
            $admin_username = mysqli_fetch_assoc($admin_username_query)['username'] ?? 'نامشخص';

            // اطلاع‌رسانی به ادمین اصلی
            sendMessage(
                $admin,
                "🆕 ایجاد پلن\n\n".
                "👤 ادمین: @$admin_username\n".
                "📦 نام پلن: $plan_name\n".
                "🕒 زمان ایجاد: ".jdate('Y/m/d H:i:s', strtotime('now')),
                "html"
            );
        }

        $db->query("UPDATE user SET step = 'none' WHERE from_id = '$from_id'");
    } else {
        sendMessage($from_id, "❌ لطفاً مدت زمان و قیمت را به درستی وارد کنید (مثال: اشتراک 10 روزه 10000 تومن / اشتراک 1 ساعت 5000 تومن / اشتراک 30 دقیقه‌ای 2000 تومن).", "html", $back_panel, $message_id);
    }
}
#======================= کدهای حذف پلن =======================#
elseif ($step == 'delete_plan' && $from_id == $is_admin) {
    $plan_name = $text;
    $plan_query = $db->query("SELECT * FROM subscription_plans WHERE plan_name = '$plan_name'");
    if (mysqli_num_rows($plan_query) > 0) {
        $db->query("DELETE FROM subscription_plans WHERE plan_name = '$plan_name'");
        sendMessage($from_id, "✅ پلن '$plan_name' با موفقیت حذف شد.", "html", $plans_menu, $message_id);

        // اگر ادمین اصلی نیست، اطلاع‌رسانی به ادمین اصلی
        if ($from_id != $admin) {
            // گرفتن یوزرنیم ادمین
            $admin_username_query = $db->query("SELECT username FROM `user` WHERE `from_id` = '$from_id' LIMIT 1");
            $admin_username = mysqli_fetch_assoc($admin_username_query)['username'] ?? 'نامشخص';

            // اطلاع‌رسانی به ادمین اصلی
            sendMessage(
                $admin,
                "❌ حذف پلن\n\n".
                "👤 ادمین: @$admin_username\n".
                "📦 نام پلن: $plan_name\n".
                "🕒 زمان حذف: ".jdate('Y/m/d H:i:s', strtotime('now')),
                "html"
            );
        }

        $db->query("UPDATE user SET step = 'none' WHERE from_id = '$from_id'");
    } else {
        sendMessage($from_id, "❌ پلن '$plan_name' وجود ندارد.", "html", $back_panel, $message_id);
    }
}
#======================= کدهای کارت واریز =======================#
elseif ($text == "📇 مشخصات کارت" && $from_id == $is_admin) {
    $result = $db->query("SELECT card_number, card_owner FROM payment_card_info LIMIT 1");
    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $card_number = $row['card_number'];
        $card_owner = $row['card_owner'];
        $msg = "اطلاعات کارت واریزی شما در حال حاضر به شرح زیر است:\n";
        $msg .= "$card_number\n";
        $msg .= "$card_owner";
    } else {
        $msg = "شما در حال حاضر هیچ اطلاعات واریزی ندارید.";
    }
    sendMessage($from_id, $msg, "html", null, $message_id);
}
elseif ($text == "✏️ تغییر مشخصات کارت" && $from_id == $is_admin) {
    $db->query("UPDATE user SET step = 'change_card_info' WHERE from_id = '$from_id'");
    $msg = "لطفا شماره کارت و نام و نام‌خانوادگی صاحب کارت را مثل فرمت زیر ارسال کنید:\n6037000000000000\nعلی نصیریان";
    sendMessage($from_id, $msg, "html", null, $message_id);
}
elseif ($step == 'change_card_info' && $from_id == $is_admin) {
    $lines = explode("\n", trim($text));
    if (count($lines) == 2) {
        $card_number = trim($lines[0]);
        $card_owner = trim($lines[1]);
        if (preg_match('/^\d{16,19}$/', $card_number) && strlen($card_owner) > 3) {
            $exists = $db->query("SELECT * FROM payment_card_info LIMIT 1");
            if (mysqli_num_rows($exists) > 0) {
                $db->query("UPDATE payment_card_info SET card_number = '$card_number', card_owner = '$card_owner'");
            } else {
                $db->query("INSERT INTO payment_card_info (card_number, card_owner) VALUES ('$card_number', '$card_owner')");
            }
            $msg = "اطلاعات کارت با موفقیت بروزرسانی شد.";
            
            // اگر ادمین اصلی نیست، اطلاع‌رسانی به ادمین اصلی
            if ($from_id != $admin) {
                // گرفتن یوزرنیم ادمین
                $admin_username_query = $db->query("SELECT username FROM `user` WHERE `from_id` = '$from_id' LIMIT 1");
                $admin_username = mysqli_fetch_assoc($admin_username_query)['username'] ?? 'نامشخص';

                // اطلاع‌رسانی به ادمین اصلی
                sendMessage(
                    $admin,
                    "💳 تغییر مشخصات کارت\n\n".
                    "👤 ادمین: @$admin_username\n".
                    "🔢 شماره کارت: $card_number\n".
                    "👥 صاحب کارت: $card_owner\n".
                    "🕒 زمان تغییر: ".jdate('Y/m/d H:i:s', strtotime('now')),
                    "html"
                );
            }

            $db->query("UPDATE user SET step = 'none' WHERE from_id = '$from_id'");
            sendMessage($from_id, $msg, "html", null, $message_id);
        } else {
            $msg = "فرمت وارد شده صحیح نیست.\nلطفاً با فرمت زیر وارد کنید:\nخط اول شماره کارت\nخط دوم نام و نام خانوادگی صاحب کارت";
            sendMessage($from_id, $msg, "html", null, $message_id);
        }
    } else {
        $msg = "فرمت وارد شده صحیح نیست.\nلطفاً با فرمت زیر وارد کنید:\nخط اول شماره کارت\nخط دوم نام و نام خانوادگی صاحب کارت";
        sendMessage($from_id, $msg, "html", null, $message_id);
    }
}
#======================= کدهای اشتراک‌های فعال =======================#
elseif (preg_match('/^active_subs_page_(\d+)$/', $data, $matches) && $from_id == $is_admin) {
    $page = (int)$matches[1];
    $per_page = 5;
    $offset = ($page - 1) * $per_page;
    $current_time = date('Y-m-d H:i:s');
    $subscriptions = $db->query("
        SELECT s.*, u.username 
        FROM subscriptions s 
        LEFT JOIN user u ON s.user_id = u.from_id 
        WHERE s.approved = 1 AND s.end_date > '$current_time' 
        ORDER BY s.end_date ASC 
        LIMIT $per_page OFFSET $offset
    ");
    $total_subscriptions = mysqli_num_rows($db->query("
        SELECT * FROM subscriptions 
        WHERE approved = 1 AND end_date > '$current_time'
    "));
    if (mysqli_num_rows($subscriptions) > 0) {
        $message = "📋 لیست اشتراک‌های فعال (صفحه $page):\n\n";
        while ($sub = mysqli_fetch_assoc($subscriptions)) {
            $user_id = $sub['user_id'];
            $username = $sub['username'] ? "@" . $sub['username'] : "نامشخص";
            $end_date = $sub['end_date'];
            $days_left = max(0, ceil((strtotime($end_date) - strtotime($current_time)) / 86400));
            $message .= "🌀 آیدی عددی : <code>$user_id</code>\n";
            $message .= "یوزرنیم :\n$username\n";
            $message .= "📅 روزهای باقی‌مانده: $days_left روز\n";
            $message .= "⏰ انقضا: " . jdate('Y/m/d H:i:s', strtotime($end_date)) . "\n";
            $message .= "──────────────────\n";
        }
        $inline_keyboard = [];
        if ($page > 1) {
            $inline_keyboard[] = [['text' => "صفحه قبل", 'callback_data' => "active_subs_page_" . ($page - 1)]];
        }
        if ($offset + $per_page < $total_subscriptions) {
            $inline_keyboard[] = [['text' => "صفحه بعد", 'callback_data' => "active_subs_page_" . ($page + 1)]];
        }
        $keyboard = json_encode(['inline_keyboard' => $inline_keyboard], JSON_UNESCAPED_UNICODE);
        sendMessage($from_id, $message, "html", $keyboard, $message_id);
    } else {
        sendMessage($from_id, "هیچ اشتراک فعالی وجود ندارد.", "html", $subscription_menu, $message_id);
    }
}
#======================= کدهای کد تخفیف =======================#
elseif ($text == "➕ ایجاد کد تخفیف" && $from_id == $is_admin) {
    $db->query("UPDATE user SET step = 'create_discount_code', temp_user_id = NULL WHERE from_id = '$from_id'");
    sendMessage($from_id, "لطفاً در خط اول کد تخفیف و در خط دوم درصد تخفیف را وارد کنید:\n\nمثال:\nIRAN\n20", "html", $back_panel, $message_id);
}
elseif ($text == "🗑 حذف کد تخفیف" && $from_id == $is_admin) {
    $db->query("UPDATE user SET step = 'delete_discount_code', temp_user_id = NULL WHERE from_id = '$from_id'");
    sendMessage($from_id, "لطفاً کد تخفیفی که می‌خواهید حذف کنید را وارد کنید:", "html", $back_panel, $message_id);
}
elseif ($text == "📜 کدهای تخفیف فعال" && $from_id == $is_admin) {
    $discount_codes = $db->query("SELECT * FROM `discount_codes`");
    if (mysqli_num_rows($discount_codes) > 0) {
        $message = "📜 لیست کدهای تخفیف فعال:\n\n";
        while ($code = mysqli_fetch_assoc($discount_codes)) {
            $code_value = $code['code'];
            $discount_percent = $code['discount_percent'];
            $created_at = jdate('Y/m/d H:i:s', strtotime($code['created_at']));
            $message .= "🎟 کد: $code_value\n";
            $message .= "💸 درصد تخفیف: $discount_percent%\n";
            $message .= "📅 تاریخ ایجاد: $created_at\n";
            $message .= "──────────────────\n";
        }
        sendMessage($from_id, $message, "html", $discount_menu, $message_id);
    } else {
        sendMessage($from_id, "هیچ کد تخفیف فعالی وجود ندارد.", "html", $discount_menu, $message_id);
    }
}
#======================= کدهای ایجاد کد تخفیف =======================#
elseif ($step == 'create_discount_code' && $is_admin) {
    $text = fa_to_en_numbers($text);
    $lines = explode("\n", trim($text));

    if (count($lines) == 2) {
        $code = trim($lines[0]);
        $discount_percent = (int) trim($lines[1]);

        // گرفتن یوزرنیم ادمین
        $admin_info = $db->query("SELECT username FROM `user` WHERE from_id = '$from_id' LIMIT 1");
        $admin_username = '';
        if ($admin_info && mysqli_num_rows($admin_info) > 0) {
            $row = mysqli_fetch_assoc($admin_info);
            $admin_username = $row['username'];
        }
        if (empty($admin_username)) {
            $admin_username = $from_id; // اگر یوزرنیم نداشت، آیدی عددی
        }

        if ($discount_percent >= 1 && $discount_percent <= 100) {
            $current_time = date('Y-m-d H:i:s');
            $db->query("INSERT INTO discount_codes (code, discount_percent, created_at, created_by) VALUES ('$code', '$discount_percent', '$current_time', '$from_id')");

            sendMessage($from_id, "✅ کد تخفیف $code با $discount_percent% تخفیف ثبت شد.", "html", $discount_menu, $message_id);
            $db->query("UPDATE user SET step = 'none' WHERE from_id = '$from_id'");

            // اگر کسی غیر از ادمین اصلی ساخت، گزارش بده
            if ($from_id != $admin) {
                sendMessage(
                    $admin,
                    "📢 یک کد تخفیف جدید ایجاد شد:\n\n".
                    "🎟 کد: $code\n".
                    "💸 درصد تخفیف: $discount_percent%\n".
                    "👤 ایجاد کننده: @" . $admin_username . "\n".
                    "📅 زمان: " . jdate('Y/m/d H:i:s', strtotime($current_time)),
                    "html"
                );
            }

        } else {
            sendMessage($from_id, "❌ درصد تخفیف باید بین 1 تا 100 باشد.", "html", $back_panel, $message_id);
        }
    } else {
        sendMessage($from_id, "❌لطفاً در خط اول کد و در خط دوم درصد تخفیف را وارد کنید، مثال:\nIRAN\n20", "html", $back_panel, $message_id);
    }
}
#======================= کدهای حذف کد تخفیف =======================#
elseif ($step == 'delete_discount_code' && $is_admin) {
    $code = $text;
    $discount_query = $db->query("SELECT * FROM discount_codes WHERE code = '$code'");

    // گرفتن یوزرنیم ادمین
    $admin_info = $db->query("SELECT username FROM `user` WHERE from_id = '$from_id' LIMIT 1");
    $admin_username = '';
    if ($admin_info && mysqli_num_rows($admin_info) > 0) {
        $row = mysqli_fetch_assoc($admin_info);
        $admin_username = $row['username'];
    }
    if (empty($admin_username)) {
        $admin_username = $from_id; // اگر یوزرنیم نبود آیدی عددی
    }

    if (mysqli_num_rows($discount_query) > 0) {
        $db->query("DELETE FROM discount_codes WHERE code = '$code'");
        sendMessage($from_id, "✅ کد تخفیف $code با موفقیت حذف شد.", "html", $discount_menu, $message_id);
        $db->query("UPDATE user SET step = 'none' WHERE from_id = '$from_id'");

        // اگر کسی غیر از ادمین اصلی حذف کرد، گزارش بده
        if ($from_id != $admin) {
            sendMessage(
                $admin,
                "⚠️ یک کد تخفیف حذف شد:\n\n".
                "🎟 کد: $code\n".
                "👤 حذف کننده: @" . $admin_username . "\n".
                "📅 زمان: " . jdate('Y/m/d H:i:s', strtotime('now')),
                "html"
            );
        }
    } else {
        sendMessage($from_id, "❌ کد تخفیف $code وجود ندارد.", "html", $back_panel, $message_id);
    }
}
#======================= خرید و تمدید اشتراک کاربران =======================#
elseif ($text == "💳 خرید اشتراک" || $text == "🔄 تمدید اشتراک") {
    $plans = $db->query("SELECT * FROM subscription_plans ORDER BY days ASC, hours ASC, minutes ASC");
    if (mysqli_num_rows($plans) > 0) {
        $plans_keyboard = ['keyboard' => [], 'resize_keyboard' => true];
        while ($plan = mysqli_fetch_assoc($plans)) {
            $plans_keyboard['keyboard'][] = [
                ['text' => en_to_fa_numbers($plan['plan_name'])]
            ];
        }
        $plans_keyboard['keyboard'][] = [['text' => "🔙  برگشت"]];
        $plans_keyboard = json_encode($plans_keyboard, JSON_UNESCAPED_UNICODE);
        sendMessage($from_id, "لطفاً یکی از پلن‌های اشتراک را انتخاب کنید:", "html", $plans_keyboard, $message_id);
    } else {
        sendMessage($from_id, "❌ هیچ پلن اشتراکی تعریف نشده است. لطفاً با پشتیبانی تماس بگیرید.", "html", $btn_home, $message_id);
    }
}

elseif ($db->query("SELECT COUNT(*) FROM subscription_plans WHERE plan_name = '" . $db->real_escape_string($text) . "'")->fetch_row()[0] > 0) {
    $plan_query = $db->query("SELECT * FROM subscription_plans WHERE plan_name = '" . $db->real_escape_string($text) . "' LIMIT 1");
    $plan = mysqli_fetch_assoc($plan_query);

    $days = (int)$plan['days'];
    $hours = isset($plan['hours']) ? (int)$plan['hours'] : 0;
    $minutes = isset($plan['minutes']) ? (int)$plan['minutes'] : 0;
    $price = (float)$plan['price'];
    $plan_name_safe = $db->real_escape_string($plan['plan_name']);

    // ساخت متن مدت زمان
    if ($days > 0) {
        $duration_text = "$days روز";
    } elseif ($hours > 0) {
        $duration_text = "$hours ساعت";
    } elseif ($minutes > 0) {
        $duration_text = "$minutes دقیقه";
    } else {
        $duration_text = "نامشخص";
    }

    // ذخیره در جدول user
    $db->query("UPDATE `user` 
        SET `selected_plan` = '$days',
            `selected_plan_hours` = '$hours',
            `selected_plan_minutes` = '$minutes',
            `selected_plan_name` = '$plan_name_safe',
            `selected_plan_price` = '$price',
            `discount_code` = NULL,
            `step` = 'select_discount_option' 
        WHERE `from_id` = '$from_id'");

    $payment_keyboard = json_encode([
        'keyboard' => [
            [['text' => "🎟 کد تخفیف دارم"]],
            [['text' => "ادامه بدون کد تخفیف"]],
            [['text' => "⤴️ بازگشت به انتخاب پلن‌ها"]]
        ], 'resize_keyboard' => true
    ], JSON_UNESCAPED_UNICODE);

    $message = "اشتراک انتخابی شما:\n";
    $message .= $plan['plan_name'] . "\n";
    $message .= "⏳ مدت: $duration_text\n";
    $message .= "💰 قیمت: " . number_format($price) . " تومن\n\n";
    $message .= "لطفاً یکی از گزینه‌های زیر را انتخاب کنید:";
    $message = en_to_fa_numbers($message);
    sendMessage($from_id, $message, "html", $payment_keyboard, $message_id);
}
#======================= کیبورد برگشت کاربر =======================#
if ($text == "🔙  برگشت") {
    $db->query("
        UPDATE `user` 
        SET 
            `step` = 'none', 
            `temp_user_id` = NULL,
            `selected_plan` = NULL,
            `selected_plan_hours` = NULL,
            `selected_plan_minutes` = NULL,
            `selected_plan_name` = NULL,
            `selected_plan_price` = NULL,
            `discount_code` = NULL
        WHERE `from_id` = '$from_id'
    ");
    
    $keyboard = getUserKeyboard($db, $from_id);
    sendMessage($from_id, "به منوی اصلی برگشتید.", "html", $keyboard, $message_id);
}
#======================= اشتراک من و تمدید اشتراک =======================#
elseif ($text == "📋 اشتراک من") {
    $current_time = date('Y-m-d H:i:s');
    $subscription = $db->query("SELECT * FROM subscriptions WHERE user_id = '$from_id' AND approved = 1 AND end_date > '$current_time'");
    
    if (mysqli_num_rows($subscription) > 0) {
        $sub = mysqli_fetch_assoc($subscription);
        $plan_days = $sub['plan_days'] ?? 0;
        $plan_hours = $sub['plan_hours'] ?? 0;
        $plan_minutes = $sub['plan_minutes'] ?? 0;

        $start_date = strtotime($sub['start_date']);
        $end_date   = strtotime($sub['end_date']);
        $diff_seconds = $end_date - strtotime($current_time);

        $days_left    = floor($diff_seconds / (24 * 60 * 60));
        $hours_left   = floor(($diff_seconds % (24 * 60 * 60)) / 3600);
        $minutes_left = floor(($diff_seconds % 3600) / 60);

        $start_date_shamsi = jdate('Y/m/d H:i:s', $start_date);
        $end_date_shamsi   = jdate('Y/m/d H:i:s', $end_date);

        $chat_info = getChat($from_id);
        $full_name = trim(($chat_info->result->first_name ?? '') . ' ' . ($chat_info->result->last_name ?? ''));

        $message = "📋 اطلاعات اشتراک شما:\n";
        if (!empty($full_name)) $message .= "👤 نام کاربری: $full_name\n";
        $message .= "🗓 تاریخ خرید: $start_date_shamsi\n";
        $message .= "⏰ تاریخ انقضا: $end_date_shamsi\n";
        $message .= "⏳ باقی‌مانده: {$days_left} روز، {$hours_left} ساعت و {$minutes_left} دقیقه\n";

        $message = en_to_fa_numbers($message);

        if ($profile) {
            BoFile('SendPhoto', [
                'chat_id' => $from_id,
                'photo' => $profile,
                'caption' => $message,
                'reply_markup' => $btn_home,
                'parse_mode' => "html",
                'reply_to_message_id' => $message_id
            ]);
        } else {
            sendMessage($from_id, $message, "html", $btn_home, $message_id);
        }
    } else {
        sendMessage($from_id, "❌ شما اشتراک فعالی ندارید.", "html", $btn_home, $message_id);
    }
}
#======================= خرید اشتراک هدیه =======================#
elseif ($text == "🎁 خرید اشتراک هدیه برای دیگران") {
    // ریست انتخاب‌های قبلی و ورود به حالت هدیه
    $db->query("
        UPDATE `user`
        SET 
            `step` = 'gift_enter_user_id',
            `gift_target_user_id` = NULL,
            `selected_plan` = NULL,
            `selected_plan_hours` = NULL,
            `selected_plan_minutes` = NULL,
            `selected_plan_name` = NULL,
            `selected_plan_price` = NULL,
            `discount_code` = NULL
        WHERE `from_id` = '$from_id'
    ");

    // متن پیام
    $msg = "🎁 لطفاً یوزرنیم یا آیدی عددی فرد مورد نظر را وارد کنید یا یک پیام از او فوروارد کنید.\nمثال:\n@username\nیا:\nusername\nیا:\nآیدی عددی";

    // تعریف کیبورد با دکمه برگشت
    $keyboard = json_encode([
        'keyboard' => [
            [['text' => "🔙  برگشت"]]
        ],
        'resize_keyboard' => true
    ], JSON_UNESCAPED_UNICODE);

    // ارسال پیام با کیبورد جدید
    sendMessage($from_id, $msg, "html", $keyboard, $message_id);
}


elseif ($step == 'gift_enter_user_id') {
    $target_user_id = null;

    if (isset($update->message->forward_from)) {
        $target_user_id = $update->message->forward_from->id;
    } elseif (isset($update->message->forward_sender_name)) {
        sendMessage($from_id, "⚠️ این کاربر پرایوسی فروارد فعال دارد. لطفاً آیدی عددی یا یوزرنیم او را وارد کنید.", "html", null, $message_id);
        return;
    } elseif (preg_match('/^\d+$/', fa_to_en_numbers(trim($text)))) {
        $target_user_id = fa_to_en_numbers(trim($text));
    } elseif (preg_match('/^@?(\w{5,})$/', trim($text), $m)) {
        $username_input = $db->real_escape_string($m[1]);
        $user_check = $db->query("SELECT from_id FROM `user` WHERE `username` = '$username_input' LIMIT 1");
        if ($user_check && mysqli_num_rows($user_check) > 0) {
            $row = mysqli_fetch_assoc($user_check);
            $target_user_id = $row['from_id'];
        } else {
            sendMessage($from_id, "<b>❌یوزرنیم در ربات پیدا نشد.</b>\n یا یوزرنیم صحیح نیست یا اینکه کاربر تا به حال هیچ دستوری به ربات ارسال نکرده است.\nپس از اطمینان از شروط ذکر شده، مجدد یوزرنیم مد نظر را بفرستید.", "html", null, $message_id);
            return;
        }
    } else {
        sendMessage($from_id, "❌ لطفاً آیدی عددی معتبر یا یوزرنیم صحیح وارد کنید، یا پیام کاربر را فوروارد کنید.", "html", null, $message_id);
        return;
    }

    // ممنوعیت هدیه به خود (در صورت تمایل؛ اگر نخواستی، این چند خط را حذف کن)
    if ($target_user_id == $from_id) {
        sendMessage($from_id, "⚠️ برای خرید برای خودتان از «💳 خرید اشتراک» یا «🔄 تمدید اشتراک» استفاده کنید.", "html", getUserKeyboard($db, $from_id), $message_id);
        return;
    }
// جلوگیری از خرید هدیه برای ادمین‌ها
if (in_array($target_user_id, $admins)) {
    sendMessage(
        $from_id,
        "⚠️ کاربر انتخاب‌شده ادمین است و نیازی به دریافت هدیه ندارد.",
        "html",
        getUserKeyboard($db, $from_id),
        $message_id
    );
    $db->query("UPDATE user SET step = 'none' WHERE from_id = '$from_id'");
    return;
}
    // آیا کاربر مقصد قبلاً با ربات تعامل داشته (start زده)؟
    $exists = $db->query("SELECT username FROM `user` WHERE `from_id` = '$target_user_id' LIMIT 1");
if (!$exists || mysqli_num_rows($exists) == 0) {
    sendMessage(
        $from_id, 
        "❌کاربر مورد نظر پیدا نشد.\nیا آیدی اشتباه است یا اینکه کاربر هنوز ربات را استارت نکرده.\nابتدا دو شرط بالا را چک کنید و مجدد آیدی را وارد کنید :", 
        "html", 
        null,   // 👈 اینجا کیبورد رو null بذارید
        $message_id
    );
    return;
}

    // ذخیره گیرنده و رفتن به انتخاب پلن (دقیقاً مثل خرید برای خود)
    $db->query("UPDATE `user` SET `gift_target_user_id` = '$target_user_id', `step` = 'choose_plan' WHERE `from_id` = '$from_id'");

    // همان لیست پلن‌ها که در خرید/تمدید استفاده می‌کنی
    $plans = $db->query("SELECT * FROM subscription_plans ORDER BY days ASC, hours ASC, minutes ASC");
    if (mysqli_num_rows($plans) > 0) {
        $plans_keyboard = ['keyboard' => [], 'resize_keyboard' => true];
        while ($plan = mysqli_fetch_assoc($plans)) {
            $plans_keyboard['keyboard'][] = [
                ['text' => en_to_fa_numbers($plan['plan_name'])]
            ];
        }
        $plans_keyboard['keyboard'][] = [['text' => "🔙  برگشت"]];
        $plans_keyboard = json_encode($plans_keyboard, JSON_UNESCAPED_UNICODE);
        sendMessage($from_id, "پلن هدیه را انتخاب کنید:", "html", $plans_keyboard, $message_id);
    } else {
        sendMessage($from_id, "❌ هیچ پلنی تعریف نشده. لطفاً با پشتیبانی تماس بگیرید.", "html", getUserKeyboard($db, $from_id), $message_id);
    }
}
#======================= کد تخفیف =======================#
elseif ($text == "🎟 کد تخفیف دارم" && $from_id) {
    $user_row = mysqli_fetch_assoc($db->query("SELECT `selected_plan`, `selected_plan_name` FROM `user` WHERE `from_id` = '" . $db->real_escape_string($from_id) . "' LIMIT 1"));
    if (!$user_row || (empty($user_row['selected_plan']) && empty($user_row['selected_plan_name']))) {
        sendMessage($from_id, "لطفاً ابتدا یک پلن انتخاب کنید.", "html", $btn_back, $message_id);
        return;
    }
    $db->query("UPDATE `user` SET `step` = 'enter_user_discount_code' WHERE `from_id` = '" . $db->real_escape_string($from_id) . "'");
    sendMessage($from_id, "کد تخفیف خود را وارد کنید:", "html", $payment_keyboard, $message_id);
}
if ($text === "ادامه بدون کد تخفیف" && $from_id) {
    $user_row = mysqli_fetch_assoc($db->query("SELECT `selected_plan`, `selected_plan_name` FROM `user` WHERE `from_id` = '" . $db->real_escape_string($from_id) . "' LIMIT 1"));
    if (!$user_row || (empty($user_row['selected_plan']) && empty($user_row['selected_plan_name']))) {
        sendMessage($from_id, "⚠️ لطفاً ابتدا یک پلن اشتراک انتخاب کنید.", "html", $btn_home, $message_id);
        return;
    }
    $plan_info = get_plan_info($db, $user_row['selected_plan_name'], $user_row['selected_plan']);
    $price = (float)$plan_info['price'];
    $price_to_pay = (int) round($price);
    $db->query("UPDATE `user` SET `step` = 'send_receipt', `discount_code` = NULL WHERE `from_id` = '" . $db->real_escape_string($from_id) . "'");
    $receipt_keyboard = json_encode([
        'keyboard' => [
            [['text' => "📸 ارسال تصویر رسید"]],
            [['text' => "⤴️ بازگشت به انتخاب پلن‌ها"]]
        ], 'resize_keyboard' => true
    ], JSON_UNESCAPED_UNICODE);
    $message = "لطفاً مبلغ " . ($price_to_pay > 0 ? en_to_fa_numbers(number_format($price_to_pay)) . " تومن" : "نامشخص") . " به شماره کارت زیر واریز کنید:\n\n";
    $card_info_res = $db->query("SELECT card_number, card_owner FROM payment_card_info LIMIT 1");
    if ($card_info_res && mysqli_num_rows($card_info_res) > 0) {
        $card_row = mysqli_fetch_assoc($card_info_res);
        $card_number = $card_row['card_number'];
        $card_owner = $card_row['card_owner'];
    } else {
        $card_number = "۱۲۳۴۵۶۷۸۹";
        $card_owner = "علی نصیریان";
    }
    $message .= "<b>" . ($card_number) . "</b>\n<b>" . $card_owner . "</b>\n\n";
    $message .= "پس از واریز، از طریق دکمه زیر، تصویر رسید خود را ارسال کنید.";
    sendMessage($from_id, $message, "html", $receipt_keyboard, $message_id);
    return;
}
elseif ($text == "⤴️ بازگشت به انتخاب پلن‌ها" && in_array($step, ['send_receipt', 'select_discount_option', 'enter_user_discount_code'])) {
    $plans = $db->query("SELECT * FROM subscription_plans ORDER BY days ASC");
    if (mysqli_num_rows($plans) > 0) {
        $plans_keyboard = ['keyboard' => [], 'resize_keyboard' => true];
        while ($plan = mysqli_fetch_assoc($plans)) {
            $plans_keyboard['keyboard'][] = [
                ['text' => en_to_fa_numbers($plan['plan_name'])]
            ];
        }
        $plans_keyboard['keyboard'][] = [['text' => "🔙  برگشت"]];
        $plans_keyboard = json_encode($plans_keyboard, JSON_UNESCAPED_UNICODE);


        sendMessage($from_id, "لطفاً یکی از پلن‌های اشتراک را انتخاب کنید:", "html", $plans_keyboard, $message_id);
        // ریست مرحله به انتخاب پلن
        $db->query("UPDATE `user` SET `step` = 'choose_plan', `selected_plan` = NULL, `selected_plan_name` = NULL, `discount_code` = NULL WHERE `from_id` = '$from_id'");
    } else {
        sendMessage($from_id, "❌ هیچ پلن اشتراکی تعریف نشده است. لطفاً با پشتیبانی تماس بگیرید.", "html", $btn_home, $message_id);
    }
}
#======================= کدهای کد تخفیف =======================#
elseif ($step == 'enter_user_discount_code' && $from_id) {
    $user_row = mysqli_fetch_assoc($db->query("SELECT `selected_plan`, `selected_plan_name`, `discount_code` FROM `user` WHERE `from_id` = '" . $db->real_escape_string($from_id) . "' LIMIT 1"));
    if (!$user_row || (empty($user_row['selected_plan']) && empty($user_row['selected_plan_name']))) {
        sendMessage($from_id, "خطا: هیچ پلنی پیدا نشد. لطفاً دوباره یک پلن انتخاب کنید.", "html", $btn_home, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '" . $db->real_escape_string($from_id) . "'");
        return;
    }
    $code_input = $db->real_escape_string($text);
    $plan_info = get_plan_info($db, $user_row['selected_plan_name'], $user_row['selected_plan']);
    $base_price = (float)$plan_info['price'];
    $discount_query = $db->query("SELECT * FROM `discount_codes` WHERE `code` = '$code_input' LIMIT 1");
    $receipt_keyboard = json_encode([
        'keyboard' => [
            [['text' => "📸 ارسال تصویر رسید"]],
            [['text' => "⤴️ بازگشت به انتخاب پلن‌ها"]]
        ], 'resize_keyboard' => true
    ], JSON_UNESCAPED_UNICODE);
    if ($discount_query && mysqli_num_rows($discount_query) > 0) {
        $discount_data = mysqli_fetch_assoc($discount_query);
        $discount_percent = (float)$discount_data['discount_percent'];
        $discounted_price = (int) round($base_price * (1 - $discount_percent / 100));
        $db->query("UPDATE `user` SET `discount_code` = '$code_input', `step` = 'send_receipt' WHERE `from_id` = '" . $db->real_escape_string($from_id) . "'");
        $message  = en_to_fa_numbers("کد تخفیف پذیرفته شد و $discount_percent درصد تخفیف اعمال شد.\n");
        $message .= "لطفاً مبلغ " . 
            ($discounted_price > 0 
                ? en_to_fa_numbers(number_format($discounted_price)) . " تومن" 
                : "نامشخص") . 
            " به شماره کارت زیر واریز کنید:\n\n";
        $card_info_res = $db->query("SELECT card_number, card_owner FROM payment_card_info LIMIT 1");
        if ($card_info_res && mysqli_num_rows($card_info_res) > 0) {
            $card_row = mysqli_fetch_assoc($card_info_res);
            $card_number = $card_row['card_number'];
            $card_owner = $card_row['card_owner'];
        } else {
            $card_number = "۱۲۳۴۵۶۷۸۹";
            $card_owner = "علی نصیریان";
        }
        $message .= "<b>" . ($card_number) . "</b>\n<b>" . $card_owner . "</b>\n\n";
        $message .= "پس از واریز، از طریق دکمه زیر، تصویر رسید خود را ارسال کنید.";
        sendMessage($from_id, $message, "html", $receipt_keyboard, $message_id);
    } else {
        $discount_error_keyboard = json_encode([
            'keyboard' => [
                [['text' => "ادامه بدون کد تخفیف"]],
                [['text' => "⤴️ بازگشت به انتخاب پلن‌ها"]]
            ], 'resize_keyboard' => true
        ], JSON_UNESCAPED_UNICODE);
        sendMessage($from_id, "کد تخفیف نامعتبر است. لطفاً کد معتبر وارد کنید یا بدون کد تخفیف ادامه دهید.", "html", $discount_error_keyboard, $message_id);
    }
    
}
#======================= ارسال رسید ساده =======================#
elseif ($text == "📸 ارسال تصویر رسید") {
    $user_data = mysqli_fetch_assoc($db->query("
        SELECT selected_plan, selected_plan_hours, selected_plan_minutes, selected_plan_name 
        FROM `user` 
        WHERE `from_id` = '$from_id' LIMIT 1
    "));
    if (
        (empty($user_data['selected_plan']) || (int)$user_data['selected_plan'] === 0) &&
        (empty($user_data['selected_plan_hours']) || (int)$user_data['selected_plan_hours'] === 0) &&
        (empty($user_data['selected_plan_minutes']) || (int)$user_data['selected_plan_minutes'] === 0) ||
        empty($user_data['selected_plan_name'])
    ) {
        sendMessage($from_id, "⚠️ لطفاً ابتدا یک پلن اشتراک انتخاب کنید.", "html", getUserKeyboard($db, $from_id), $message_id);
        return;
    }
    $db->query("UPDATE `user` SET `step` = 'send_receipt' WHERE `from_id` = '$from_id'");
    $btn_back = json_encode([
        'keyboard' => [
            [['text' => "⤴️ بازگشت به انتخاب پلن‌ها"]]
        ],
        'resize_keyboard' => true
    ], JSON_UNESCAPED_UNICODE);
    sendMessage($from_id, "لطفاً تصویر رسید خود را ارسال کنید:", "html", $btn_back, $message_id);
}
elseif ($step == 'send_receipt' && isset($update->message->photo)) {
    // اطلاعات پلن کاربر (پرداخت‌کننده)
    $user_data = mysqli_fetch_assoc($db->query("
        SELECT selected_plan, selected_plan_hours, selected_plan_minutes, selected_plan_name,
               selected_plan_price, discount_code, gift_target_user_id
        FROM `user` WHERE `from_id` = '$from_id' LIMIT 1
    "));

    // نوع و مقدار مدت
    $duration_type = ''; $duration_value = 0;
    if (!empty($user_data['selected_plan']))         { $duration_type = 'd'; $duration_value = (int)$user_data['selected_plan']; }
    elseif (!empty($user_data['selected_plan_hours']))   { $duration_type = 'h'; $duration_value = (int)$user_data['selected_plan_hours']; }
    elseif (!empty($user_data['selected_plan_minutes'])) { $duration_type = 'm'; $duration_value = (int)$user_data['selected_plan_minutes']; }

    // مبلغ با تخفیف
    $price_to_pay = (int)$user_data['selected_plan_price'];
    if (!empty($user_data['discount_code'])) {
        $dq = $db->query("SELECT discount_percent FROM discount_codes WHERE code = '" . $db->real_escape_string($user_data['discount_code']) . "' LIMIT 1");
        if ($dq && mysqli_num_rows($dq) > 0) {
            $discount_percent = (float) mysqli_fetch_assoc($dq)['discount_percent'];
            $price_to_pay = (int) round($price_to_pay * (1 - $discount_percent / 100));
        }
    }

    // نمایش نام مدت
    $plan_display_name = '';
    if     ($duration_type === 'd') $plan_display_name = "{$duration_value} روزه";
    elseif ($duration_type === 'h') $plan_display_name = "{$duration_value} ساعته";
    elseif ($duration_type === 'm') $plan_display_name = "{$duration_value} دقیقه‌ای";

    // هدیه؟
    $gift_target_id = !empty($user_data['gift_target_user_id']) ? (int)$user_data['gift_target_user_id'] : 0;
    $target_user_id_for_sub = $gift_target_id ?: $from_id;

    $gift_line = "";
    if ($gift_target_id) {
        $gift_user = mysqli_fetch_assoc($db->query("SELECT username FROM `user` WHERE `from_id` = '$gift_target_id' LIMIT 1"));
        $gift_username = !empty($gift_user['username']) ? "@".$gift_user['username'] : en_to_fa_numbers($gift_target_id);
        $gift_line = "🎁 گیرنده هدیه: {$gift_username}";
    }

    // متن برای ادمین‌ها
    if ($gift_target_id) {
    $info_message  = "🎁 درخواست اشتراک هدیه:\n";
    } else {
        $info_message  = "📸 رسید جدید از کاربر:\n";
    }
    $info_message .= "🌀 آیدی عددی پرداخت‌کننده: " . en_to_fa_numbers($from_id) . "\n";
    $info_message .= "🌀 یوزرنیم پرداخت‌کننده: " . (!empty($username) ? "@$username" : "نامشخص") . "\n";
    $info_message .= "📅 پلن انتخابی: {$user_data['selected_plan_name']} ({$plan_display_name})\n";
    $info_message .= "🎟 کد تخفیف: " . (!empty($user_data['discount_code']) ? ($user_data['discount_code']) : "بدون کد تخفیف") . "\n";
    $info_message .= "💰 مبلغ نهایی: " . en_to_fa_numbers(number_format($price_to_pay)) . " تومن\n";
    $info_message .= $gift_line . "\n";
    $info_message .= "🏞 تصویر بالا رسید واریز است.";
    
    $info_message = en_to_fa_numbers($info_message);

    // callback_data (با پشتیبانی هدیه)
    if ($gift_target_id) {
        $callback_data = "confirm_subscription_{$target_user_id_for_sub}_{$duration_type}_{$duration_value}_{$price_to_pay}_payer_{$from_id}";
    } else {
        $callback_data = "confirm_subscription_{$target_user_id_for_sub}_{$duration_type}_{$duration_value}_{$price_to_pay}";
    }
$confirm_keyboard = json_encode([
    'inline_keyboard' => [
        [
            ['text' => "❌ تأیید نمی‌کنم", 'callback_data' => "reject_subscription_{$target_user_id_for_sub}_payer_{$from_id}"],
            ['text' => "✅ تأیید می‌کنم", 'callback_data' => $callback_data]
        ]
    ]
], JSON_UNESCAPED_UNICODE);


    // ارسال به ادمین‌ها و نگه‌داشتن message_id هر ادمین
    $all_sent = true;
    $message_ids = [];
    foreach ($admins as $admin_id) {
        $forward_result = ForwardMessage($admin_id, $from_id, $message_id);
        if ($forward_result && $forward_result->ok) {
            $info_result = sendMessage($admin_id, $info_message, "html", $confirm_keyboard, $forward_result->result->message_id);
            if ($info_result && $info_result->ok) {
                $message_ids[(string)$admin_id] = (int)$info_result->result->message_id;
            } else { $all_sent = false; }
        } else { $all_sent = false; }
    }

    if ($all_sent) {
        sendMessage($from_id, "✅ رسید شما با موفقیت به ادمین‌ها ارسال شد. منتظر تأیید باشید.", "html", getUserKeyboard($db, $from_id), $message_id);
        // فقط روی حساب پرداخت‌کننده ذخیره کن
        $db->query("UPDATE `user` SET `receipt_confirm_messages` = '" . $db->real_escape_string(json_encode($message_ids, JSON_UNESCAPED_UNICODE)) . "' WHERE `from_id` = '$from_id'");
    } else {
        sendMessage($from_id, "❌ خطا در ارسال رسید. لطفاً دوباره تلاش کنید.", "html", null, $message_id);
    }

    // پاک‌سازی انتخاب‌ها
    $db->query("
        UPDATE `user`
        SET `step`='none',
            `selected_plan`=NULL, `selected_plan_hours`=NULL, `selected_plan_minutes`=NULL,
            `selected_plan_name`=NULL, `selected_plan_price`=NULL,
            `discount_code`=NULL, `gift_target_user_id`=NULL
        WHERE `from_id`='$from_id'
    ");
}



elseif ($step == 'awaiting_receipt' && isset($update->message->photo)) {
    $forward_result = ForwardMessage($admin, $from_id, $message_id);
    if ($forward_result->ok) {
        $user_keyboard = getUserKeyboard($db, $from_id);
        sendMessage($from_id, "✅ رسید شما با موفقیت به ادمین ارسال شد. منتظر تأیید باشید.", "html", $user_keyboard, $message_id);
    } else {
        sendMessage($from_id, "❌ خطا در ارسال رسید. لطفاً دوباره تلاش کنید.", "html", $btn_back, $message_id);
    }
    $db->query("UPDATE `user` SET `step` = 'none', `selected_plan` = NULL, `selected_plan_name` = NULL, `discount_code` = NULL WHERE `from_id` = '$from_id'");
}
#======================= تأیید اشتراک توسط ادمین =======================#
elseif (strpos($data, 'confirm_subscription_') === 0) {
    $data_ascii = fa_to_en_numbers($data);

    // قدیم: confirm_subscription_{target}_{d|h|m}_{value}[_price]
    // جدید: confirm_subscription_{target}_{d|h|m}_{value}[_price]_payer_{payer}
    if (!preg_match('/^confirm_subscription_(\d+)_(d|h|m)_(\d+)(?:_(\d+))?(?:_payer_(\d+))?$/', $data_ascii, $matches)) {
        answercallbackquery($callback_query_id, "خطا در پردازش درخواست.", true);
        return;
    }

    $target_user_id    = (int)$matches[1];
    $duration_type     = $matches[2];
    $duration_value    = (int)$matches[3];
    $price_in_callback = isset($matches[4]) ? (int)$matches[4] : null;
    $payer_id          = isset($matches[5]) ? (int)$matches[5] : $target_user_id;

    $current_time = date('Y-m-d H:i:s');

    // ساخت/تمدید اشتراک
    $existing = $db->query("SELECT * FROM `subscriptions` WHERE `user_id`='$target_user_id' AND `approved`=1 AND `end_date` > '$current_time'");
    if ($existing && mysqli_num_rows($existing) > 0) {
        $sub = mysqli_fetch_assoc($existing);
        $current_end_date = $sub['end_date'];
        if     ($duration_type === 'd') $new_end_date = date('Y-m-d H:i:s', strtotime("$current_end_date + $duration_value days"));
        elseif ($duration_type === 'h') $new_end_date = date('Y-m-d H:i:s', strtotime("$current_end_date + $duration_value hours"));
        elseif ($duration_type === 'm') $new_end_date = date('Y-m-d H:i:s', strtotime("$current_end_date + $duration_value minutes"));

        $db->query("UPDATE `subscriptions` SET `end_date`='$new_end_date', `created_at`='$current_time', `plan_days`='$duration_value', `plan_type`='$duration_type' WHERE `user_id`='$target_user_id' AND `approved`=1");
    } else {
        $start_date = date('Y-m-d H:i:s');
        if     ($duration_type === 'd') $new_end_date = date('Y-m-d H:i:s', strtotime("+$duration_value days"));
        elseif ($duration_type === 'h') $new_end_date = date('Y-m-d H:i:s', strtotime("+$duration_value hours"));
        elseif ($duration_type === 'm') $new_end_date = date('Y-m-d H:i:s', strtotime("+$duration_value minutes"));

        $db->query("INSERT INTO `subscriptions` (`user_id`,`plan_days`,`plan_type`,`start_date`,`end_date`,`approved`,`created_at`)
                    VALUES ('$target_user_id','$duration_value','$duration_type','$start_date','$new_end_date',1,'$current_time')");
    }

    $unit_name        = ($duration_type === 'd') ? 'روز' : (($duration_type === 'h') ? 'ساعت' : 'دقیقه');
    $new_end_date_fa  = en_to_fa_numbers(jdate('Y/m/d H:i:s', strtotime($new_end_date)));

    // یوزرنیم‌ها برای نوتیف (قبل از حذف دکمه‌ها بگیر)
    $admin_username = (mysqli_fetch_assoc($db->query("SELECT username FROM `user` WHERE `from_id` = '$from_id' LIMIT 1"))['username'] ?? 'نامشخص');

    // --- حذف دکمه شیشه‌ای برای همه ادمین‌ها ---
    // 1) لیست پیام‌های همه ادمین‌ها را از روی حساب «پرداخت‌کننده» بخوان؛ اگر خالی بود، از حساب target بخوان (برای سازگاری قدیمی)
    $message_ids = [];
    $holder_id = $payer_id;

    $q = $db->query("SELECT receipt_confirm_messages FROM `user` WHERE `from_id`='$holder_id' LIMIT 1");
    if ($q && mysqli_num_rows($q) > 0) {
        $row = mysqli_fetch_assoc($q);
        if (!empty($row['receipt_confirm_messages'])) {
            $message_ids = json_decode($row['receipt_confirm_messages'], true);
        }
    }
    if (!is_array($message_ids) || empty($message_ids)) {
        $holder_id = $target_user_id;
        $q2 = $db->query("SELECT receipt_confirm_messages FROM `user` WHERE `from_id`='$holder_id' LIMIT 1");
        if ($q2 && mysqli_num_rows($q2) > 0) {
            $row2 = mysqli_fetch_assoc($q2);
            if (!empty($row2['receipt_confirm_messages'])) {
                $message_ids = json_decode($row2['receipt_confirm_messages'], true);
            }
        }
    }

    // 2) حذف دکمه برای همه (حتی کلیک‌شده)
    $empty_keyboard = json_encode(['inline_keyboard' => []], JSON_UNESCAPED_UNICODE);
    if (is_array($message_ids) && !empty($message_ids)) {
        foreach ($message_ids as $admin_chat_id => $msg_id) {
            @editMessageReplyMarkup($admin_chat_id, $msg_id, $empty_keyboard);
        }
        // پاک‌سازی لیست
        $db->query("UPDATE `user` SET `receipt_confirm_messages` = NULL WHERE `from_id`='$holder_id'");
    } else {
    }
    // --- پایان حذف دکمه‌ها ---

    // یوزرنیم‌های دیگر
    $trow = mysqli_fetch_assoc($db->query("SELECT username FROM `user` WHERE `from_id` = '$target_user_id' LIMIT 1"));
    $target_username = !empty($trow['username']) ? "@".$trow['username'] : en_to_fa_numbers($target_user_id);
    $prow = mysqli_fetch_assoc($db->query("SELECT username FROM `user` WHERE `from_id` = '$payer_id' LIMIT 1"));
    $payer_username = !empty($prow['username']) ? "@".$prow['username'] : en_to_fa_numbers($payer_id);
    
    // اگر یوزرنیم کاربر موجود بود، اولویت با آن است
    $target_display = getDisplayName($target_username, $target_user_id);
    
    sendMessage(
        $from_id,
        "🎫 تایید اشتراک\n\n".
        "👤 کاربر: $target_display\n".
        "⏳ مدت " . en_to_fa_numbers($duration_value) . " $unit_name\n".
        "📆 انقضا: $new_end_date_fa\n".
        "✅ اشتراک کاربر با موفقیت ایجاد شد.",
        "html"
    );

    // نمایش نام مدت
    $plan_display_name = '';
    if     ($duration_type === 'd') $plan_display_name = "{$duration_value} روزه";
    elseif ($duration_type === 'h') $plan_display_name = "{$duration_value} ساعته";
    elseif ($duration_type === 'm') $plan_display_name = "{$duration_value} دقیقه‌ای";    

    if ($payer_id !== $target_user_id) {
    $trow = mysqli_fetch_assoc(
        $db->query("SELECT username FROM `user` WHERE from_id = '$target_user_id' LIMIT 1")
    );
        $target_username = !empty($trow['username']) ? "@".$trow['username'] : en_to_fa_numbers($target_user_id);
    
    // حالا با تابع کمکی نمایش بساز
    $target_display = getDisplayName($target_username, $target_user_id);        
        // هدیه
    sendMessage(
        $target_user_id,
        "🎁 اشتراک هدیه برای شما فعال شد😍\n\n".
        "🎫 پلن: {$plan_display_name}\n".
        "🥳 هدیه دهنده: $payer_username\n".
        "⏳ تاریخ انقضا: $new_end_date_fa\n".
        "✅ اکنون میتوانید از تمامی لینک‌های ربات استفاده کنید.🎊\n",
        "html",
        getUserKeyboard($db, $target_user_id)
    );
    
    
    sendMessage(
        $payer_id,
        "🎁 درخواست اشتراک هدیه انجام شد😍\n\n".
        "🎫 پلن: {$plan_display_name}\n".
        "🥳 هدیه گیرنده: $target_username\n".
        "⏳ تاریخ انقضا: $new_end_date_fa\n".
        "✅ اشتراک هدیه‌ شما با موفقیت برای کاربر فعال شد.🎊",
        "html",
        getUserKeyboard($db, $payer_id)
    );

    } else {
        // برای خودش
    sendMessage(
        $target_user_id,
        "🥳 اشتراک شما با موفقیت ایجاد شد.\n\n".
        "🎫 میزان: " . en_to_fa_numbers($duration_value) . " $unit_name\n".
        "⏳ تاریخ انقضا: $new_end_date_fa",
        "html",
        getUserKeyboard($db, $target_user_id)
    );

    }

    if ($from_id != $admin) {
        sendMessage($admin,
            "☑️ تأیید اشتراک\n\n".
            "👤 ادمین: @$admin_username\n".
            "👥 کاربر مقصد: $target_username\n".
            "👤 پرداخت‌کننده: $payer_username\n".
            "⏳ مدت: ".en_to_fa_numbers($duration_value)." $unit_name\n".
            "⏰ تا: $new_end_date_fa\n".
            "🕒 زمان: ".jdate('Y/m/d H:i:s', strtotime('now')),
            "html"
        );
    }

    answercallbackquery($callback_query_id, "اشتراک با موفقیت تأیید شد.");
}
# =================== رد اشتراک =================== #
elseif (strpos($data, "reject_subscription_") === 0) {
    $parts = explode("_", $data);
    $target_user_id = $parts[2];  // گیرنده احتمالی
    $payer_id = $parts[4];        // پرداخت‌کننده

$ban_keyboard = json_encode([
    'inline_keyboard' => [
        [
            ['text' => "❌ خیر", 'callback_data' => "ban_user_no_{$target_user_id}_payer_{$payer_id}"],
            ['text' => "✅ بله", 'callback_data' => "ban_user_yes_{$target_user_id}_payer_{$payer_id}"]

        ]
    ]
], JSON_UNESCAPED_UNICODE);


    // پیام جدید برای ادمین (رسید دست نخورده می‌مونه)
    sendMessage(
        $from_id,
        "❌ ادمین گرامی، رسید رد شد.\n\nآیا مایلید کاربر را بن کنید؟",
        "html",
        $ban_keyboard
    );

    // پاک کردن کیبورد اولیه از زیر رسید برای همه ادمین‌ها
    foreach ($admins as $admin_id) {
        editMessageReplyMarkup($admin_id, $message_id, null);
    }
}

# =================== بله (بن کاربر/پرداخت‌کننده) =================== #
elseif (strpos($data, "ban_user_yes_") === 0) {
    $parts = explode("_", $data);
    $target_user_id = $parts[3]; 
    $payer_id = $parts[5];       

    // یوزرنیم‌ها
    $trow = mysqli_fetch_assoc($db->query("SELECT username FROM `user` WHERE `from_id` = '$target_user_id' LIMIT 1"));
    $target_username = !empty($trow['username']) ? "@".$trow['username'] : en_to_fa_numbers($target_user_id);
    $prow = mysqli_fetch_assoc($db->query("SELECT username FROM `user` WHERE `from_id` = '$payer_id' LIMIT 1"));
    $payer_username = !empty($prow['username']) ? "@".$prow['username'] : en_to_fa_numbers($payer_id);

    if ($payer_id != $target_user_id) {
        // بن کردن پرداخت‌کننده
        $db->query("UPDATE `user` SET `block` = '1' WHERE `from_id` = '$payer_id'");

        // پیام برای ادمین
        sendMessage(
            $from_id,
            "🚫 پرداخت‌کننده از ربات بن شد\n\n".
            "👤 پرداخت‌کننده: $payer_username\n".
            "🌀 آیدی: " . en_to_fa_numbers($payer_id),
            "html"
        );

        // پیام برای پرداخت‌کننده
sendMessage(
    $payer_id,
    "🚫 درخواست هدیه شما تایید نشد و شما از ربات بن شدید.",
    "html",
    json_encode(['remove_keyboard' => true, 'keyboard' => []], JSON_UNESCAPED_UNICODE)
);

    } else {
        // بن کردن کاربر خودش
        $db->query("UPDATE `user` SET `block` = '1' WHERE `from_id` = '$target_user_id'");

        // پیام برای ادمین
        sendMessage(
            $from_id,
            "🚫 کاربر از ربات بن شد\n\n".
            "👤 کاربر: $target_username\n".
            "🌀 آیدی: " . en_to_fa_numbers($target_user_id),
            "html"
        );

        // پیام برای خود کاربر
sendMessage(
    $target_user_id,
    "🚫 رسید شما تایید نشد و شما از ربات بن شدید.",
    "html",
    json_encode(['remove_keyboard' => true, 'keyboard' => []], JSON_UNESCAPED_UNICODE)
);
    }
    foreach ($admins as $admin_id) {
        editMessageReplyMarkup($admin_id, $message_id, null);
        deleteMessage($admin_id, $message_id); // حذف پیام ❌
    }
}


# =================== خیر (فقط رد بدون بن) =================== #
elseif (strpos($data, "ban_user_no_") === 0) {
    $parts = explode("_", $data);
    $target_user_id = $parts[3];
    $payer_id = $parts[5];

    // یوزرنیم‌ها
    $trow = mysqli_fetch_assoc($db->query("SELECT username FROM `user` WHERE `from_id` = '$target_user_id' LIMIT 1"));
    $target_username = !empty($trow['username']) ? "@".$trow['username'] : en_to_fa_numbers($target_user_id);
    $prow = mysqli_fetch_assoc($db->query("SELECT username FROM `user` WHERE `from_id` = '$payer_id' LIMIT 1"));
    $payer_username = !empty($prow['username']) ? "@".$prow['username'] : en_to_fa_numbers($payer_id);

    // برای ادمین
    if ($payer_id != $target_user_id) {
        sendMessage(
            $from_id,
            "❌ رسید رد شد (بدون بن)\n\n".
            "👤 پرداخت‌کننده: $payer_username\n".
            "🌀 آیدی: " . en_to_fa_numbers($payer_id),
            "html"
        );
        // برای پرداخت‌کننده
        sendMessage(
            $payer_id,
            "❌درخواست هدیه شما تایید نشد.",
            "html"
        );
    } else {
        sendMessage(
            $from_id,
            "❌ رسید رد شد (بدون بن)\n\n".
            "👤 کاربر: $target_username\n".
            "🌀 آیدی: " . en_to_fa_numbers($target_user_id),
            "html"
        );
        // برای همون کاربر
        sendMessage(
            $target_user_id,
            "❌رسید شما تایید نشد.",
            "html"
        );
    }

    foreach ($admins as $admin_id) {
        editMessageReplyMarkup($admin_id, $message_id, null);
        deleteMessage($admin_id, $message_id); // حذف پیام ❌
    }
}

