<?php
#=============================# کپچا #=============================#
// ---------- Step 0: Parse Update ----------
$update = json_decode(file_get_contents('php://input'));

$from_id = null;
$message_id = null;
$text = null;
$data = null;
$callback_query_id = null;
$isCallback = false;

if (isset($update->callback_query)) {
    $isCallback = true;
    $callback_query_id = $update->callback_query->id ?? null;
    $from_id = $update->callback_query->from->id ?? null;
    $message_id = $update->callback_query->message->message_id ?? null;
    $data = $update->callback_query->data ?? null;
} elseif (isset($update->message)) {
    $from_id = $update->message->from->id ?? null;
    $message_id = $update->message->message_id ?? null;
    $text = $update->message->text ?? null;
}

// ---------- Step 1: sendCaptcha (with anti-duplicate guard) ----------
function sendCaptcha($from_id, $id) {
    global $db, $is_admin;

    // اگر ادمین بود، کپچا رو رد کن و فایل رو مستقیم بفرست
    if ($is_admin) {
        send($from_id, null, $id, 'send');
        // null کردن getFile بعد از موفقیت (فرض بر موفقیت send)
        $db->query("UPDATE `user` SET `getFile`=NULL WHERE `from_id`='{$from_id}'");
        return;
    }

    // ضدتکرار
    $chk = $db->query("SELECT `step`,`captcha_msg_id` FROM `user` WHERE `from_id`='{$from_id}' LIMIT 1");
    if ($chk && mysqli_num_rows($chk) > 0) {
        $u = mysqli_fetch_assoc($chk);
        if ($u['step'] === 'captcha' && !empty($u['captcha_msg_id'])) {
            return;
        }
    }

    // سوال تصادفی از DB
    $q = $db->query("SELECT * FROM `captcha_pool` ORDER BY RAND() LIMIT 1");
    if ($q && mysqli_num_rows($q) > 0) {
        $row = mysqli_fetch_assoc($q);
        $question      = $row['question'];
        $image_file_id = $row['image_file_id'] ?? null;
        $audio_file_id = $row['audio_file_id'] ?? null;

        // آماده‌سازی گزینه‌ها
        $opts = [
            ['text' => $row['option1'], 'ok' => ((int)$row['correct_option'] === 1)],
            ['text' => $row['option2'], 'ok' => ((int)$row['correct_option'] === 2)],
            ['text' => $row['option3'], 'ok' => ((int)$row['correct_option'] === 3)],
        ];
        shuffle($opts);

        $correctIndex = 1;
        foreach ($opts as $i => $o) {
            if ($o['ok']) {
                $correctIndex = $i+1;
                break;
            }
        }

        // ست کردن وضعیت کاربر
        $safeId = $db->real_escape_string($id);
        $db->query("UPDATE `user`
                        SET `step`='captcha',
                            `getFile`='{$safeId}',
                            `captcha_answer`='{$correctIndex}',
                            `captcha_attempts`=0,
                            `captcha_msg_id`=NULL,
                            `captcha_photo_msg_id`=NULL,
                            `captcha_audio_msg_id`=NULL
                    WHERE `from_id`='{$from_id}'");

        // کیبورد اینلاین
        $rowBtns = [];
        foreach ($opts as $i => $o) {
            $rowBtns[] = ['text' => $o['text'], 'callback_data' => "captcha_{$id}_".($i+1)];
        }
        $keyboard = json_encode(['inline_keyboard' => [ $rowBtns ]], JSON_UNESCAPED_UNICODE);

        // --- ارسال در پیام‌های جدا ---
        $photoMsgId = null;
        $audioMsgId = null;
        $replyToId = null;

        // 1) اول عکس (بدون کپشن و بدون کیبورد)
        if (!empty($image_file_id)) {
            $photoRes = SendPhoto($from_id, $image_file_id, '', '', '', '');
            $photoMsgId = $photoRes->result->message_id ?? null;
            if ($photoMsgId) {
                $db->query("UPDATE `user` SET `captcha_photo_msg_id`={$photoMsgId} WHERE `from_id`='{$from_id}'");
                $replyToId = $photoMsgId;
            }
        }

        // 2) سپس موزیک یا ویس (اگر وجود داشته باشد، بدون کپشن و بدون کیبورد)
        if (!empty($audio_file_id)) {
            // فرض می‌کنیم SendAudio برای موزیک/ویس استفاده می‌شود
            $audioRes = SendAudio($from_id, $audio_file_id, '', '', '', '');
            $audioMsgId = $audioRes->result->message_id ?? null;
            if ($audioMsgId) {
                $db->query("UPDATE `user` SET `captcha_audio_msg_id`={$audioMsgId} WHERE `from_id`='{$from_id}'");
                $replyToId = $audioMsgId;
            }
        }

        // 3) سپس سؤال + گزینه‌ها (این پیام را به‌عنوان captcha_msg ذخیره می‌کنیم)
        if ($replyToId) {
            $msgRes = sendMessage(
                $from_id,
                "🔐جهت دریافت فایل‌ها ابتدا کپچای زیر را حل کنید.\n────────────\n\n<b>{$question}</b>",
                "html",
                $keyboard,
                $replyToId
            );
        } else {
            $msgRes = sendMessage(
                $from_id,
                "🔐جهت دریافت فایل‌ها ابتدا کپچای زیر را حل کنید.\n────────────\n\n<b>{$question}</b>",
                "html",
                $keyboard
            );
        }


        $msgId  = $msgRes->result->message_id ?? null;
if ($msgId) {
    $db->query("UPDATE `user` SET `captcha_msg_id`={$msgId} WHERE `from_id`='{$from_id}'");
} else {
    // اگر به هر دلیلی ارسال متن Fail شد
}


    } else {
        // fallback ریاضی (DB خالی)
        $a = rand(1,10); $b = rand(1,10); $answer = $a + $b;
        $wrong1 = $answer + rand(-5,5); while ($wrong1 == $answer || $wrong1 < 0) $wrong1 = $answer + rand(-5,5);
        $wrong2 = $answer + rand(-5,5); while ($wrong2 == $answer || $wrong2 == $wrong1 || $wrong2 < 0) $wrong2 = $answer + rand(-5,5);
        $vals = [$answer,$wrong1,$wrong2]; shuffle($vals);

        $safeId = $db->real_escape_string($id);
        $db->query("UPDATE `user`
                        SET `step`='captcha',
                            `getFile`='{$safeId}',
                            `captcha_answer`='{$answer}',
                            `captcha_attempts`=0,
                            `captcha_msg_id`=NULL,
                            `captcha_photo_msg_id`=NULL,
                            `captcha_audio_msg_id`=NULL
                    WHERE `from_id`='{$from_id}'");

        $keyboard = json_encode([
            'inline_keyboard' => [[
                ['text'=>(string)$vals[0],'callback_data'=>"captcha_{$id}_{$vals[0]}"],
                ['text'=>(string)$vals[1],'callback_data'=>"captcha_{$id}_{$vals[1]}"],
                ['text'=>(string)$vals[2],'callback_data'=>"captcha_{$id}_{$vals[2]}"],
            ]]
        ], JSON_UNESCAPED_UNICODE);

        $res   = sendMessage($from_id, "🔐جهت دریافت فایل‌ها ابتدا کپچای زیر را حل کنید:\n\n$a + $b = ؟", "html", $keyboard);
        $msgId = $res->result->message_id ?? null;
        if ($msgId) $db->query("UPDATE `user` SET `captcha_msg_id`={$msgId} WHERE `from_id`='{$from_id}'");
    }
}
// ---------- Step 2: Callback Handler ----------
if ($isCallback && isset($data)) {
    if (preg_match('/^captcha_(.+)_(\d+)$/u', $data, $m)) {
        $fileId = $m[1];
        $user_answer = (int)$m[2]; // گزینه انتخاب شده توسط کاربر

        $q = $db->query("SELECT `captcha_answer`,`captcha_attempts`,`captcha_msg_id`,`captcha_photo_msg_id`,`captcha_audio_msg_id`
                         FROM `user` WHERE `from_id`='{$from_id}' LIMIT 1");

        $row = ($q && mysqli_num_rows($q)>0) ? mysqli_fetch_assoc($q) : null;

        $correct  = $row ? (int)$row['captcha_answer']   : null;
        $attempts = $row ? (int)$row['captcha_attempts'] : 0;
        $capMsgId = $row ? (int)$row['captcha_msg_id']   : null;
        $photoMsgId = $row ? (int)$row['captcha_photo_msg_id'] : null;
        $audioMsgId = $row ? (int)$row['captcha_audio_msg_id'] : null;

        $maxAttempts = 2;

        if ($correct !== null && $user_answer === $correct) {
            // ✅ پاسخ صحیح
            if ($capMsgId) { @deleteMessage($from_id, $capMsgId); }
            if ($photoMsgId) { @deleteMessage($from_id, $photoMsgId); }
            if ($audioMsgId) { @deleteMessage($from_id, $audioMsgId); }

            $db->query("UPDATE `user` 
                           SET `step`='none',
                               `captcha_answer`=NULL,
                               `captcha_attempts`=0,
                               `captcha_msg_id`=NULL,
                               `captcha_photo_msg_id`=NULL,
                               `captcha_audio_msg_id`=NULL
                     WHERE `from_id`='{$from_id}'");

            // نوتیف کشویی بالای صفحه
            if (!empty($callback_query_id)) {
                answercallbackquery($callback_query_id, "✅ پاسخ صحیح بود، فایل‌ها در حال ارسال هستند", false);
            }

            // بازگشت به روند اصلی → اینجا حتماً باید همون منطق send اجرا بشه
            send($from_id, null, $fileId, 'send');
            // null کردن getFile بعد از موفقیت (فرض بر موفقیت send)
            $db->query("UPDATE `user` SET `getFile`=NULL WHERE `from_id`='{$from_id}'");

        } else {
            // ❌ پاسخ اشتباه
            $attempts++;
            $db->query("UPDATE `user` SET `captcha_attempts`={$attempts} WHERE `from_id`='{$from_id}'");

            if ($attempts >= $maxAttempts) {
                if ($capMsgId) { @deleteMessage($from_id, $capMsgId); }
                if ($photoMsgId) { @deleteMessage($from_id, $photoMsgId); }
                if ($audioMsgId) { @deleteMessage($from_id, $audioMsgId); }

                $db->query("UPDATE `user` 
                               SET `step`='none',
                                   `captcha_answer`=NULL,
                                   `captcha_attempts`=0,
                                   `captcha_msg_id`=NULL,
                                   `captcha_photo_msg_id`=NULL,
                                   `captcha_audio_msg_id`=NULL
                         WHERE `from_id`='{$from_id}'");

                // ارسال پیام به جای پاپ‌آپ
                $retryKeyboard = json_encode([
                    'inline_keyboard' => [[
                        ['text' => 'امتحان مجدد', 'callback_data' => "retry_captcha_{$fileId}"]
                    ]]
                ], JSON_UNESCAPED_UNICODE);

                sendMessage($from_id, "⛔️ فرصت شما تمام شد. دوباره روی لینک بزنید.", "html", $retryKeyboard);

                // همچنان جواب کال‌بک برای جلوگیری از چرخش
                if (!empty($callback_query_id)) {
                    answercallbackquery($callback_query_id, "", false); // خالی برای جلوگیری از ارور
                }
            } else {
                // پاپ‌آپ اشتباه اول
                if (!empty($callback_query_id)) {
                    answercallbackquery($callback_query_id, "🛑 پاسخ اشتباه بود، شما یکبار دیگر فرصت دارید.", true);
                }
            }
        }
        exit;
    } elseif (preg_match('/^retry_captcha_(.+)$/', $data, $m)) {
        $fileId = $m[1];

        // حذف پیام شکست و دکمه
        @deleteMessage($from_id, $message_id);

        // شروع مجدد کپچا (بدون پیام واسط)
        sendCaptcha($from_id, $fileId);

        // جواب کال‌بک برای جلوگیری از چرخش
        if (!empty($callback_query_id)) {
            answercallbackquery($callback_query_id, "", false);
        }
        exit;
    }
}


// ---------- Step 3: Text Answer ----------
if (!$isCallback && $user['step']=='captcha' && isset($text)) {
    $id = $user['getFile'];
    $answer   = (string)$user['captcha_answer'];
    $attempts = isset($user['captcha_attempts']) ? (int)$user['captcha_attempts'] : 0;
    $capMsgId = isset($user['captcha_msg_id']) ? (int)$user['captcha_msg_id'] : null;
    $photoMsgId = isset($user['captcha_photo_msg_id']) ? (int)$user['captcha_photo_msg_id'] : null;
    $audioMsgId = isset($user['captcha_audio_msg_id']) ? (int)$user['captcha_audio_msg_id'] : null;
    $maxAttempts = 2;

    if (trim($text) === $answer) {
        if ($capMsgId) { @deleteMessage($from_id, $capMsgId); }
        if ($photoMsgId) { @deleteMessage($from_id, $photoMsgId); }
        if ($audioMsgId) { @deleteMessage($from_id, $audioMsgId); }

        $db->query("UPDATE `user` 
                       SET `step`='none',
                           `captcha_answer`=NULL,
                           `captcha_attempts`=0,
                           `captcha_msg_id`=NULL,
                           `captcha_photo_msg_id`=NULL,
                           `captcha_audio_msg_id`=NULL
                 WHERE `from_id`='{$from_id}'");

        // ✅ پیام ریز بالای صفحه (برای ورودی متنی نمی‌شه چون callback نیست)
        sendMessage($from_id, "✅ پاسخ صحیح بود، فایل‌ها در حال ارسال هستند.", "html");

        send($from_id, $message_id, $id, 'send');
        // null کردن getFile بعد از موفقیت (فرض بر موفقیت send)
        $db->query("UPDATE `user` SET `getFile`=NULL WHERE `from_id`='{$from_id}'");

    } else {
        $attempts++;
        $db->query("UPDATE `user` SET `captcha_attempts`={$attempts} WHERE `from_id`='{$from_id}'");

        if ($attempts >= $maxAttempts) {
            if ($capMsgId) { @deleteMessage($from_id, $capMsgId); }
            if ($photoMsgId) { @deleteMessage($from_id, $photoMsgId); }
            if ($audioMsgId) { @deleteMessage($from_id, $audioMsgId); }

            $db->query("UPDATE `user` 
                           SET `step`='none',
                               `captcha_answer`=NULL,
                               `captcha_attempts`=0,
                               `captcha_msg_id`=NULL,
                               `captcha_photo_msg_id`=NULL,
                               `captcha_audio_msg_id`=NULL
                     WHERE `from_id`='{$from_id}'");

            // ارسال پیام به جای پاپ‌آپ برای ورودی متنی
            $retryKeyboard = json_encode([
                'inline_keyboard' => [[
                    ['text' => 'امتحان مجدد', 'callback_data' => "retry_captcha_{$id}"]
                ]]
            ], JSON_UNESCAPED_UNICODE);

            sendMessage($from_id, "⛔️ فرصت شما برای کپچا تمام شد. دوباره روی لینک بزنید.", "html", $retryKeyboard);
        } else {
            sendMessage($from_id, "🛑 پاسخ اشتباه بود، شما یکبار دیگر فرصت دارید.", "html");
        }
    }
    exit;
}
#======================= کیبورد کپچا =======================#
    $captcha_keyboard = json_encode([
        'keyboard' => [
            [['text' => "✅ فعال کردن کپچا"], ['text' => "❌ غیر فعال کردن کپچا"]],
            [['text' => "➕ ایجاد کپچا"], ['text' => "🗑 حذف کپچا"]],
            [['text' => "برگشت 🔙"]],
        ], 'resize_keyboard' => true
    ]);
#======================= کیبورد برگشت به منوی کپچا =======================#
if ($text == "بازگشت 🔙" && $is_admin) {
    // چک کردن برای حذف رکورد ناقص کپچا اگر وجود داشته باشد
    $user_query = $db->query("SELECT `step`, `getFile` FROM `user` WHERE `from_id` = '$from_id' LIMIT 1");
    if ($user_query && mysqli_num_rows($user_query) > 0) {
        $user_data = mysqli_fetch_assoc($user_query);
        $current_step = $user_data['step'];
        $captcha_id = $user_data['getFile'];

        if (strpos($current_step, 'add_captcha_') === 0 && !empty($captcha_id) && is_numeric($captcha_id)) {
            $db->query("DELETE FROM `captcha_pool` WHERE `id` = " . (int)$captcha_id);
        }
    }

    $db->query("UPDATE `user` SET `step` = 'none', `temp_user_id` = NULL, `getFile` = NULL WHERE `from_id` = '$from_id'");
    sendMessage($from_id, "به منوی کپچا برگشتید.", "html", $captcha_keyboard, $message_id);
}
#======================= کپچا مدیریت =======================#
elseif ($text == "🤖 کپچا" && $from_id == $is_admin) {
    sendMessage($from_id, "مدیریت کپچا:", "html", $captcha_keyboard);
}
elseif ($text == "✅ فعال کردن کپچا" && $from_id == $is_admin) {
    $db->query("UPDATE `settings` SET `captcha_enabled`=1");
    sendMessage($from_id, "✅ کپچا با موفقیت فعال شد.", "html", $panel);
}
elseif ($text == "❌ غیر فعال کردن کپچا" && $from_id == $is_admin) {
    $db->query("UPDATE `settings` SET `captcha_enabled`=0");
    sendMessage($from_id, "❌ کپچا با موفقیت غیر فعال شد.", "html", $panel);
}
#====++++
elseif ($text == "➕ ایجاد کپچا" && $from_id == $is_admin) {
    $keyboard = json_encode([
        'keyboard' => [
            [['text' => "بدون عکس"]],
            [['text' => "بازگشت 🔙"]],
        ], 'resize_keyboard' => true
    ]);
    $db->query("UPDATE `user` SET `step`='add_captcha_image' WHERE `from_id`='{$from_id}'");
    sendMessage($from_id, "📸 لطفاً عکس کپچا را ارسال کنید یا دکمه 'بدون عکس' را بزنید:", "html", $keyboard);
}
elseif ($user['step'] == 'add_captcha_image' && $from_id == $is_admin) {
    $image_file_id = null;
    if (isset($update->message->photo)) {
        // عکس ارسال شده، file_id آخرین (بزرگترین) عکس را بگیر
        $photos = $update->message->photo;
        $image_file_id = end($photos)->file_id;
    } elseif ($text == "بدون عکس") {
        // بدون عکس ادامه بده
        $image_file_id = null;
    } else {
        sendMessage($from_id, "❌ لطفاً یک عکس ارسال کنید یا 'بدون عکس' را انتخاب کنید.", "html");
        return;
    }

    // INSERT اولیه با image_file_id و audio_file_id خالی
    $safe_image = $db->real_escape_string($image_file_id ?? '');
    $db->query("INSERT INTO `captcha_pool` (`question`,`option1`,`option2`,`option3`,`correct_option`,`image_file_id`,`audio_file_id`)
                VALUES ('','','','',0,'{$safe_image}','')");
    $lastId = $db->insert_id;
    $db->query("UPDATE `user` SET `step`='add_captcha_audio', `getFile`='{$lastId}' WHERE `from_id`='{$from_id}'");

    $keyboard = json_encode([
        'keyboard' => [
            [['text' => "بدون موزیک"]],
            [['text' => "بازگشت 🔙"]],
        ], 'resize_keyboard' => true
    ]);
    sendMessage($from_id, "🎵 لطفاً موزیک یا ویس کپچا را ارسال کنید یا دکمه 'بدون موزیک' را بزنید:", "html", $keyboard);
}
elseif ($user['step'] == 'add_captcha_audio' && $from_id == $is_admin) {
    $audio_file_id = null;
    if (isset($update->message->audio) || isset($update->message->voice)) {
        // موزیک یا ویس ارسال شده، file_id را بگیر
        if (isset($update->message->audio)) {
            $audio_file_id = $update->message->audio->file_id;
        } elseif (isset($update->message->voice)) {
            $audio_file_id = $update->message->voice->file_id;
        }
    } elseif ($text == "بدون موزیک") {
        // بدون موزیک ادامه بده
        $audio_file_id = null;
    } else {
        sendMessage($from_id, "❌ لطفاً یک موزیک یا ویس ارسال کنید یا 'بدون موزیک' را انتخاب کنید.", "html");
        return;
    }

    // UPDATE با audio_file_id
    $safe_audio = $db->real_escape_string($audio_file_id ?? '');
    $db->query("UPDATE `captcha_pool` SET `audio_file_id`='{$safe_audio}' WHERE `id`='{$user['getFile']}'");
    $db->query("UPDATE `user` SET `step`='add_captcha_q' WHERE `from_id`='{$from_id}'");
    sendMessage($from_id, "❓ لطفاً سوال کپچا را وارد کنید:", "html", $keyboard);
}
elseif ($user['step'] == 'add_captcha_q' && $from_id == $is_admin) {
    $db->query("UPDATE `captcha_pool` SET `question`='".$db->real_escape_string($text)."' WHERE `id`='{$user['getFile']}'");
    $db->query("UPDATE `user` SET `step`='add_captcha_opt1' WHERE `from_id`='{$from_id}'");
    sendMessage($from_id, "✍️ گزینه اول را وارد کنید:", "html");
}
elseif ($user['step'] == 'add_captcha_opt1' && $from_id == $is_admin) {
    $db->query("UPDATE `captcha_pool` SET `option1`='".$db->real_escape_string($text)."' WHERE `id`='{$user['getFile']}'");
    $db->query("UPDATE `user` SET `step`='add_captcha_opt2' WHERE `from_id`='{$from_id}'");
    sendMessage($from_id, "✍️ گزینه دوم را وارد کنید:", "html");
}
elseif ($user['step'] == 'add_captcha_opt2' && $from_id == $is_admin) {
    $db->query("UPDATE `captcha_pool` SET `option2`='".$db->real_escape_string($text)."' WHERE `id`='{$user['getFile']}'");
    $db->query("UPDATE `user` SET `step`='add_captcha_opt3' WHERE `from_id`='{$from_id}'");
    sendMessage($from_id, "✍️ گزینه سوم را وارد کنید:", "html");
}
elseif ($user['step'] == 'add_captcha_opt3' && $from_id == $is_admin) {
    $db->query("UPDATE `captcha_pool` SET `option3`='".$db->real_escape_string($text)."' WHERE `id`='{$user['getFile']}'");
    $db->query("UPDATE `user` SET `step`='add_captcha_correct' WHERE `from_id`='{$from_id}'");
    sendMessage($from_id, "✅ شماره گزینه صحیح را وارد کنید (1-3):", "html");
}
elseif ($user['step'] == 'add_captcha_correct' && $from_id == $is_admin) {
    $correct = intval($text);
    if ($correct >= 1 && $correct <= 3) {
        $db->query("UPDATE `captcha_pool` SET `correct_option`='{$correct}' WHERE `id`='{$user['getFile']}'");
        $db->query("UPDATE `user` SET `step`='none', `getFile`=NULL WHERE `from_id`='{$from_id}'");
        sendMessage($from_id, "🎉 کپچا با موفقیت ثبت شد.", "html", $captcha_keyboard);
    } else {
        sendMessage($from_id, "❌ لطفاً یک عدد بین 1 تا 3 وارد کنید.", "html");
    }
}
elseif ($text == "🗑 حذف کپچا" && $from_id == $is_admin) {
    $q = $db->query("SELECT * FROM `captcha_pool`");
    if ($q && mysqli_num_rows($q)>0) {
        while ($row = mysqli_fetch_assoc($q)) {
            $btn = json_encode([
                'inline_keyboard' => [
                    [['text'=>"🗑 حذف", 'callback_data'=>"delcaptcha_{$row['id']}"]]
                ]
            ]);
            $msg = "❓ {$row['question']}";
            if (!empty($row['image_file_id'])) {
                $msg .= "\n(با عکس)";
            }
            sendMessage($from_id, $msg, "html", $btn);
        }
    } else {
        sendMessage($from_id, "هیچ کپچایی وجود ندارد.", "html");
    }
}

elseif ($isCallback && preg_match('/^delcaptcha_(\d+)/', $data, $m) && $from_id == $is_admin) {
    $cid = (int)$m[1];
    $db->query("DELETE FROM `captcha_pool` WHERE `id`={$cid}");
    answercallbackquery($callback_query_id, "✅ کپچا حذف شد", false);
    editMessageText($from_id, $message_id, "❌ کپچا حذف شد.");
}