<?php
// ==================== توابع کمکی ====================
if (!function_exists('persianToEnglishDigits')) {
    function persianToEnglishDigits($s) {
        $pers = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
        $eng  = ['0','1','2','3','4','5','6','7','8','9'];
        return str_replace($pers, $eng, $s);
    }
}
function fetchUser($db, $from_id){
    $id = $db->real_escape_string($from_id);
    $res = $db->query("SELECT * FROM `user` WHERE `from_id` = '$id' LIMIT 1");
    return $res ? mysqli_fetch_assoc($res) : null;
}
function base64url_encode($data){
    return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
}
function base64url_decode($data){
    $pad = strlen($data) % 4 ? 4 - (strlen($data) % 4) : 0;
    $data .= str_repeat('=', $pad);
    return base64_decode(strtr($data, '-_', '+/'));
}
// چک وجود ستون (استفادهٔ کم‌هزینه و اختیاری برای پشتیبانی از schemaهای قدیمی)
function columnExists($db, $table, $column) {
    $t = $db->real_escape_string($table);
    $c = $db->real_escape_string($column);
    $sql = "SELECT COUNT(*) AS c FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = '$t' AND COLUMN_NAME = '$c'";
    $res = $db->query($sql);
    if (!$res) return false;
    $r = $res->fetch_assoc();
    return ((int)$r['c'] > 0);
}
// --- migrate columns once (safe) ---
if (!columnExists($db,'votes','post_autoattach_pending')) {
    $db->query("ALTER TABLE votes ADD COLUMN post_autoattach_pending TINYINT(1) NOT NULL DEFAULT 0");
}
if (!columnExists($db,'votes','post_autoattach_done')) {
    $db->query("ALTER TABLE votes ADD COLUMN post_autoattach_done TINYINT(1) NOT NULL DEFAULT 0");
}

// نرمال‌سازی کپشن برای مقایسه
if (!function_exists('normalizeCaption')) {
    function normalizeCaption($s){
        $s = str_replace(["\r\n","\r"], "\n", (string)$s);
        return trim($s);
    }
}

#--------------کدهای جدید برای آپدیت مقادیر دیتابیس---------------#
// نوع/فایل/کپشن را از یک Message استخراج می‌کند
function extractMessageMedia($msg) {
    $type = 'text'; $file_id = null; $caption = '';
    if (isset($msg->photo))       { $type='photo';     $file_id=end($msg->photo)->file_id; $caption=$msg->caption??''; }
    elseif (isset($msg->video))   { $type='video';     $file_id=$msg->video->file_id;      $caption=$msg->caption??''; }
    elseif (isset($msg->animation)){ $type='animation';$file_id=$msg->animation->file_id;  $caption=$msg->caption??''; }
    elseif (isset($msg->audio))   { $type='audio';     $file_id=$msg->audio->file_id;      $caption=$msg->caption??''; }
    elseif (isset($msg->voice))   { $type='voice';     $file_id=$msg->voice->file_id;      $caption=$msg->caption??''; }
    elseif (isset($msg->document)){ $type='document';  $file_id=$msg->document->file_id;   $caption=$msg->caption??''; }
    elseif (isset($msg->video_note)){ $type='video_note'; $file_id=$msg->video_note->file_id; $caption=''; }
    else { $caption = $msg->text ?? ($msg->caption ?? ''); }
    return [$type, $file_id, $caption];
}

// دریافت @username کانال از طریق getChat (در صورت نبود، null)
function getChannelUsernameById($chat_id){
    $chatInfo = BoFile('getChat', ['chat_id' => $chat_id]);
    if ($chatInfo && isset($chatInfo->ok) && $chatInfo->ok){
        if (!empty($chatInfo->result->username)){
            return '@'.$chatInfo->result->username;
        }
    }
    return null;
}

// سنکرون کردن DB با تغییرات خودِ پیام کانال
if (isset($update->channel_post) || isset($update->edited_channel_post)) {
    $msg = $update->edited_channel_post ?? $update->channel_post;
    $chat_id    = $msg->chat->id ?? null;
    $message_id = $msg->message_id ?? null;
    if ($chat_id && $message_id) {
        list($t, $fid, $cap) = extractMessageMedia($msg);
        $uname = isset($msg->chat->username) && $msg->chat->username ? '@'.$msg->chat->username : getChannelUsernameById($chat_id);

        // فقط اگر رکورد موجود است بروزرسانی کن (تا برای پست‌هایی که اصلاً مدیریت‌شان دست ما نیست چیزی نسازیم)
        $row = mysqli_fetch_assoc($db->query("SELECT id FROM votes WHERE record_type='post' AND post_channel_id='".$db->real_escape_string($chat_id)."' AND post_channel_message_id=".(int)$message_id." LIMIT 1"));
        if ($row) {
            $db->query("UPDATE votes SET 
                post_type='".$db->real_escape_string($t)."',
                post_file_id='".$db->real_escape_string((string)$fid)."',
                post_caption='".$db->real_escape_string($cap)."',
                post_channel_username=".($uname ? "'".$db->real_escape_string($uname)."'" : "NULL")."
                WHERE id=".(int)$row['id']." AND record_type='post'");
        }
    }
}
// --- چسباندن خودکار برای پست‌های schedule شده ---
// فقط در اولین ارسال (channel_post) بررسی می‌کنیم
if (isset($update->channel_post) && $chat_id && $message_id) {
    $cap_now = normalizeCaption($cap);

    $res = $db->query("SELECT id, post_inline_keyboard, post_caption, post_type 
                       FROM votes 
                       WHERE record_type='post' 
                         AND post_autoattach_pending=1
                         AND post_channel_id='".$db->real_escape_string((string)$chat_id)."'
                       ORDER BY id ASC");
    if ($res) {
        while ($row = mysqli_fetch_assoc($res)) {
            $row_cap = normalizeCaption($row['post_caption']);
            if ($row_cap === $cap_now && $row['post_type'] === $t) {
                $ik = json_decode($row['post_inline_keyboard'], true);
                if (is_array($ik) && !empty($ik)) {
                    $ok = BoFile('editMessageReplyMarkup', [
                        'chat_id' => $chat_id,
                        'message_id' => $message_id,
                        'reply_markup' => json_encode(['inline_keyboard' => $ik], JSON_UNESCAPED_UNICODE)
                    ]);
                    if ($ok && isset($ok->ok) && $ok->ok) {
                        // بروزرسانی رکورد: دیگر منتظر نیست
                        $db->query("UPDATE votes SET 
                            post_channel_message_id = ".(int)$message_id.",
                            post_autoattach_pending = 0,
                            post_autoattach_done = 1,
                            post_type='".$db->real_escape_string($t)."',
                            post_file_id='".$db->real_escape_string((string)$fid)."',
                            post_caption='".$db->real_escape_string($cap)."',
                            post_channel_username=".($uname ? "'".$db->real_escape_string($uname)."'" : "NULL")."
                            WHERE id=".(int)$row['id']." AND record_type='post'");
                    }
                }
                break; // فقط اولین مچ را می‌چسبانیم
            }
        }
    }
}

// ==================== کیبورد بازگشت ====================
$menuButtonsKeyboard = json_encode([
    'keyboard' => [
        [ ['text' => "📤 ارسال پست با دکمه شیشه‌ای"] ],
        [ ['text' => "🗑 حذف دکمه‌های شیشه‌ای از پست"] ],
        [ ['text' => "✏️ ویرایش دکمه‌های شیشه‌ای پست"] ],
        [ ['text' => "برگشت 🔙"] ],
    ],
    'resize_keyboard' => true
], JSON_UNESCAPED_UNICODE);
if ($text === "🔘 دکمه شیشه‌ای" && $is_owner) {
    sendMessage($from_id, "📌 به منوی *دکمه شیشه‌ای* خوش آمدید.\n\nلطفاً یکی از گزینه‌ها را انتخاب کنید:", "Markdown", $menuButtonsKeyboard);
}
$channel_post_keyboard = json_encode([
    'keyboard' => [
        [['text' => "برگشت ←"]],
    ], 'resize_keyboard' => true
]);
if ($text == "برگشت ←" && $from_id == $is_admin) {
    $db->query("UPDATE user SET step = 'none', temp_user_id = NULL WHERE from_id = '$from_id'");
    sendMessage($from_id, "به منوی دکمه شیشه‌ای برگشتید.", "html", $menuButtonsKeyboard, $message_id);
}

// ==================== 1) شروع ارسال پست ====================
if ($text === "📤 ارسال پست با دکمه شیشه‌ای" && $is_owner) {
    $db->query("UPDATE `user` SET `step`='channel_post_id' WHERE `from_id`='".$db->real_escape_string($from_id)."'");
    sendMessage($from_id,"📢 لطفاً آیدی کانال را وارد کنید (مثال: @ChannelID یا -100...):","html",$channel_post_keyboard);
    return;
}

// ==================== 2) گرفتن آیدی کانال (با نرمال‌سازی به آیدی عددی + ذخیره یوزرنیم) ====================
$user = fetchUser($db,$from_id);
if ($user && $user['step']==='channel_post_id' && $is_owner) {
    if ($text==="برگشت ←") {
        $db->query("UPDATE `user` SET `step`='none' WHERE `from_id`='".$db->real_escape_string($from_id)."'");
        sendMessage($from_id,"↩️ برگشتید.","html",$panel);
        return;
    }
    $text_trim = trim($text);
    if (!preg_match('/^@[\w]+$/u',$text_trim) && !preg_match('/^-?\d+$/',$text_trim)){
        sendMessage($from_id,"❌ آیدی نامعتبر است. مثال: @ChannelID یا -100...","html",$channel_post_keyboard);
        return;
    }

    // بررسی اینکه ربات ادمین است (هم با username و هم با numeric کار می‌کند)
    $admins = BoFile('getChatAdministrators',['chat_id'=>$text_trim]);
    $is_bot_admin = false;
    if ($admins && isset($admins->ok) && $admins->ok){
        foreach ($admins->result as $a){ if (isset($a->user->id) && $a->user->id==$botInfo->id){ $is_bot_admin=true; break; } }
    }
    if (!$is_bot_admin){
        sendMessage($from_id,"❌ ربات در کانال $text_trim ادمین نیست.","html",$channel_post_keyboard);
        return;
    }

    // حالا یک getChat واقعی بزن تا آیدی عددی و یوزرنیم را بگیریم (normalize)
    $chatInfo = BoFile('getChat', ['chat_id' => $text_trim]);
    if (!$chatInfo || !isset($chatInfo->ok) || !$chatInfo->ok || !isset($chatInfo->result->id)) {
        sendMessage($from_id,"❌ خطا در دریافت اطلاعات کانال. دوباره تلاش کنید.", "html", $channel_post_keyboard);
        return;
    }
    $numericChatId = (int)$chatInfo->result->id; // مثال: -1001234567890
    $chatUsername = isset($chatInfo->result->username) && $chatInfo->result->username ? ('@' . $chatInfo->result->username) : null;

    // ذخیره در user.getFile به صورت "numericId|username" تا در مرحلهٔ بعد استفاده شود
    $meta = $numericChatId . '|' . ($chatUsername ?? '');
    $db->query("UPDATE `user` SET `step`='channel_post_content', `getFile`='".$db->real_escape_string($meta)."' WHERE `from_id`='".$db->real_escape_string($from_id)."'");
    sendMessage($from_id,"📎 لطفاً فایل یا متن پست را ارسال یا فوروارد کنید:","html",$channel_post_keyboard);
    return;
}


// ==================== 3) دریافت محتوا و درج رکورد پست ====================
$user = fetchUser($db,$from_id);
if ($user && $user['step']==='channel_post_content' && $is_owner) {
    if ($text==="برگشت ←"){
        $db->query("UPDATE `user` SET `step`='none',`getFile`=NULL WHERE `from_id`='".$db->real_escape_string($from_id)."'");
        sendMessage($from_id,"↩️ برگشتید.","html",$panel);
        return;
    }
    $type='text'; $file_id=null; $caption=$text ?? '';
    if (isset($update->message->photo)){ $type='photo'; $file_id=end($update->message->photo)->file_id; $caption=$update->message->caption??''; }
    elseif (isset($update->message->video)){ $type='video'; $file_id=$update->message->video->file_id; $caption=$update->message->caption??''; }
    elseif (isset($update->message->audio)){ $type='audio'; $file_id=$update->message->audio->file_id; $caption=$update->message->caption??''; }
    elseif (isset($update->message->voice)){ $type='voice'; $file_id=$update->message->voice->file_id; $caption=$update->message->caption??''; }
    elseif (isset($update->message->document)){ $type='document'; $file_id=$update->message->document->file_id; $caption=$update->message->caption??''; }

    // خواندن channel meta از user.getFile
    $channel_meta = $user['getFile'] ?? '';
    list($channel_id_part, $channel_username_part) = array_pad(explode('|', $channel_meta, 2), 2, null);
    $channel_id_num = (int)$channel_id_part;
    $channel_username = $channel_username_part ? $channel_username_part : null;
    
    $safe_caption = $db->real_escape_string($caption);
    $safe_file = $db->real_escape_string($file_id ?? '');
    $safe_type = $db->real_escape_string($type);
    
    // اگر خواستی ستون post_channel_id را به عدد تبدیل نکنی، می‌توانی آن را داخل '' هم بگذاری.
    // من این‌جا مقدار عددی بدون quotes می‌نویسم تا بعداً راحت‌تر به BIGINT تبدیل شود.
    $channel_username_sql = $channel_username !== null && $channel_username !== '' ? "'".$db->real_escape_string($channel_username)."'" : "NULL";
    
    $db->query("INSERT INTO `votes` (record_type,post_type,post_file_id,post_caption,post_owner,post_channel_id,post_channel_username,post_horizontal,post_vertical)
                VALUES ('post','$safe_type','$safe_file','$safe_caption','".$db->real_escape_string($from_id)."',". (int)$channel_id_num .", $channel_username_sql,0,0)");
    $post_id = $db->insert_id;


    $db->query("UPDATE `user` SET `step`='channel_post_buttons',`getFile`='".(int)$post_id."' WHERE `from_id`='".$db->real_escape_string($from_id)."'");
    sendMessage($from_id,"🔢 حالا تعداد دکمه‌ها را خط به خط وارد کنید.\nهر خط مثال: `1 افقی` یا `2 عمودی`.\nمثال:\n1 افقی\n2 عمودی\n3 افقی","html",$channel_post_keyboard);
    return;
}

// ==================== 4) تعیین layout دکمه‌ها (حالا پشتیبانی از چند خط و هر ترتیب) ====================
$user = fetchUser($db,$from_id);
if ($user && $user['step']==='channel_post_buttons' && $is_owner) {
    if ($text==="برگشت ←"){
        $post_id = (int)($user['getFile'] ?? 0);
        if ($post_id > 0) $db->query("DELETE FROM `votes` WHERE `id` = $post_id AND `record_type` = 'post'");
        $db->query("UPDATE `user` SET `step`='none',`getFile`=NULL WHERE `from_id`='".$db->real_escape_string($from_id)."'");
        sendMessage($from_id,"↩️ برگشتید.","html",$panel);
        return;
    }

    $raw = trim($text);
    if ($raw === '') {
        sendMessage($from_id,"❌ لطفاً حداقل یک خط با فرمت 'N افقی' یا 'N عمودی' وارد کنید.","html",$channel_post_keyboard);
        return;
    }

    // هر خط را جدا می‌کنیم
    $raw = persianToEnglishDigits($raw);
    $lines = array_filter(array_map('trim', explode("\n", $raw)));
    $layout = []; // آرایه‌ای از بلوک‌ها: هر بلوک => ['type'=>'horizontal'|'vertical','count'=>N]
    $totalButtons = 0;
    foreach ($lines as $ln) {
        $ln = trim($ln);
        $matched = false;
        // اجازه می‌دهیم هر دو ترتیب "N افقی" یا "افقی N" وارد شود
        if (preg_match('/^(\d+)\s*(افقی|عمودی)$/u', $ln, $m)) {
            $n = (int)$m[1]; $dir = $m[2];
            $matched = true;
        } elseif (preg_match('/^(افقی|عمودی)\s*(\d+)$/u', $ln, $m)) {
            $dir = $m[1]; $n = (int)$m[2];
            $matched = true;
        } else {
            $matched = false;
        }
        if (!$matched || $n <= 0) {
            sendMessage($from_id, "❌ فرمت هر خط باید مانند `1 افقی` یا `2 عمودی` باشد. خط مشکل‌دار: " . htmlspecialchars($ln), "html", $channel_post_keyboard);
            return;
        }
        $type = ($dir === 'افقی') ? 'horizontal' : 'vertical';
        $layout[] = ['type' => $type, 'count' => $n];
        $totalButtons += $n;
    }

    if ($totalButtons <= 0) {
        sendMessage($from_id, "❌ مجموع دکمه‌ها صفر است؛ لطفاً حداقل یک دکمه تعیین کنید.", "html", $channel_post_keyboard);
        return;
    }

    $post_id = (int)($user['getFile'] ?? 0);
    if ($post_id <= 0) {
        sendMessage($from_id, "❌ خطا: شناسهٔ پست نامعتبر است.", "html", $panel);
        return;
    }

    // اگر ستون post_layout وجود دارد، آن را ذخیره کن، وگرنه fallback به post_horizontal/post_vertical
    if (columnExists($db, 'votes', 'post_layout')) {
        $db->query("UPDATE `votes` SET `post_layout` = '" . $db->real_escape_string(json_encode($layout, JSON_UNESCAPED_UNICODE)) . "' WHERE `id` = $post_id AND `record_type` = 'post'");
    } else {
        // برای سازگاری: مجموع افقی/عمودی را محاسبه کرده و در ستون‌های قدیمی بگذار
        $sum_h = 0; $sum_v = 0;
        foreach ($layout as $b) { if ($b['type'] === 'horizontal') $sum_h += $b['count']; else $sum_v += $b['count']; }
        $db->query("UPDATE `votes` SET `post_horizontal` = $sum_h, `post_vertical` = $sum_v WHERE `id` = $post_id AND `record_type` = 'post'");
    }

    // ذخیرهٔ تعداد کل به عنوان مرجع (اختیاری ولی مفید) — اینجا فقط در پیام اطلاع‌رسانی استفاده می‌کنیم
    $db->query("UPDATE `user` SET `step`='channel_post_button_data' WHERE `from_id`='".$db->real_escape_string($from_id)."'");
    sendMessage($from_id, "✅ تنظیمات layout ذخیره شد. مجموع دکمه‌ها: $totalButtons\nحالا بیاید دادهٔ هر دکمه را خط به خط وارد کنید (لینک یا ایموجی).", "html", $channel_post_keyboard);
    return;
}

// ==================== 5) دریافت داده‌های دکمه‌ها و ساخت inline keyboard بر اساس layout ====================
$user = fetchUser($db,$from_id);
if ($user && $user['step']==='channel_post_button_data' && $is_owner) {
    if ($text==="برگشت ←"){
        $post_id = (int)($user['getFile'] ?? 0);
        if ($post_id > 0) $db->query("DELETE FROM `votes` WHERE `id` = $post_id AND `record_type` = 'post'");
        $db->query("UPDATE `user` SET `step`='none',`getFile`=NULL WHERE `from_id`='".$db->real_escape_string($from_id)."'");
        sendMessage($from_id,"↩️ برگشتید.","html",$panel);
        return;
    }

    $post_id = (int)($user['getFile'] ?? 0);
    if ($post_id <= 0) { sendMessage($from_id,"❌ خطا: پست پیدا نشد.", "html", $panel); return; }

    // خواندن layout از ستون post_layout در صورتی که وجود دارد، در غیر اینصورت از post_horizontal/post_vertical (سازگاری)
    $post_row = mysqli_fetch_assoc($db->query("SELECT post_layout, post_horizontal, post_vertical, post_type, post_file_id, post_caption FROM votes WHERE id=$post_id AND record_type='post'"));
    if (!$post_row) { sendMessage($from_id,"❌ خطا: پست پیدا نشد.", "html", $panel); return; }

    $layout = null;
    if (columnExists($db, 'votes', 'post_layout') && !empty($post_row['post_layout'])) {
        $decoded = json_decode($post_row['post_layout'], true);
        if (is_array($decoded)) $layout = $decoded;
    }
    if (!is_array($layout)) {
        // fallback به شیوهٔ قدیمی: یک ردیف افقی (post_horizontal) و سپس post_vertical ردیف‌های تک‌دکمه‌ای
        $h = (int)$post_row['post_horizontal'];
        $v = (int)$post_row['post_vertical'];
        $layout = [];
        if ($h > 0) $layout[] = ['type'=>'horizontal','count'=>$h];
        if ($v > 0) $layout[] = ['type'=>'vertical','count'=>$v];
    }

    // محاسبه تعداد کل دکمه‌ها بر اساس layout
    $totalButtons = 0;
    foreach ($layout as $b) { $totalButtons += (int)$b['count']; }

    // پردازش ورودی دکمه‌ها (شبیه قبل - لینک انتهای خط یا ایموجی‌ها)
    $lines = array_filter(array_map('trim', explode("\n", $text)));
    $buttonDefs = []; // هر آیتم: ['text'=>..., 'url'=>...] یا ['text'=>..., 'callback_data'=>...]
    foreach ($lines as $ln) {
        $parts = preg_split('/\s+/', $ln);
        if (count($parts) > 1 && filter_var(end($parts), FILTER_VALIDATE_URL)) {
            $url = array_pop($parts);
            $button_text = trim(implode(' ', $parts));
            if ($button_text === '') { sendMessage($from_id, "❌ متن دکمه برای لینک '$url' خالی است.", "html", $channel_post_keyboard); return; }
            $buttonDefs[] = ['text' => $button_text, 'url' => $url];
        } else {
            // هر قطعه را یک دکمه در نظر می‌گیریم (مثلاً ایموجی‌ها)
            foreach ($parts as $p) {
                $p = trim($p);
                if ($p === '') continue;
                $enc = base64url_encode($p);
                $buttonDefs[] = ['text' => $p . ' 0', 'callback_data' => "vote_emoji_{$post_id}_{$enc}"];
            }
        }
    }

    if (count($buttonDefs) !== $totalButtons) {
        sendMessage($from_id, "❌ تعداد دکمه‌ها نادرست است. بر اساس layout شما باید $totalButtons دکمه وارد کنید، ولی شما " . count($buttonDefs) . " وارد کردید.", "html", $channel_post_keyboard);
        return;
    }

    // ساخت inline keyboard بر اساس layout (پر کردن دکمه‌ها به ترتیب)
    $inline_keyboard = [];
    $idx = 0;
    foreach ($layout as $blk) {
        $cnt = (int)$blk['count'];
        if ($blk['type'] === 'horizontal') {
            $row = [];
            for ($i = 0; $i < $cnt; $i++) {
                $row[] = $buttonDefs[$idx++];
            }
            $inline_keyboard[] = $row;
        } else { // vertical -> cnt ردیف تک‌دکمه‌ای
            for ($i = 0; $i < $cnt; $i++) {
                $inline_keyboard[] = [ $buttonDefs[$idx++] ];
            }
        }
    }

    // ذخیره inline keyboard در رکورد پست (بدون دکمهٔ تأیید)
    $db->query("UPDATE `votes` SET `post_inline_keyboard` = '" . $db->real_escape_string(json_encode($inline_keyboard, JSON_UNESCAPED_UNICODE)) . "' WHERE `id` = $post_id AND `record_type` = 'post'");

    // ارسال پیش‌نمایش به مالک با اضافه کردن دکمهٔ تایید
// ارسال پیش‌نمایش به مالک با اضافه کردن دکمه‌های تایید و ذخیره
$ik_preview = $inline_keyboard;
$ik_preview[] = [
    ['text' => '✅ تایید میکنم',        'callback_data' => "confirm_post_{$post_id}"],
    ['text' => '💾 ذخیره برای زمان‌بندی', 'callback_data' => "schedule_post_{$post_id}"]
];


    $method = 'sendMessage';
    $params = ['chat_id' => $from_id, 'parse_mode' => 'html', 'reply_markup' => json_encode(['inline_keyboard' => $ik_preview], JSON_UNESCAPED_UNICODE)];
    if ($post_row['post_type'] !== 'text') {
        // برای ساده‌سازی فرض می‌کنیم نام فیلد ارسالی همان `post_type` است (photo/video/audio/document/voice)
        $ptype = $post_row['post_type'];
        $params[$ptype] = $post_row['post_file_id'];
        $params['caption'] = $post_row['post_caption'];
        $method = 'send' . ucfirst($ptype);
    } else {
        $params['text'] = $post_row['post_caption'];
    }

    $r = BoFile($method, $params);
    if ($r && isset($r->ok) && $r->ok) {
        $db->query("UPDATE `user` SET `step`='channel_post_confirm' WHERE `from_id`='".$db->real_escape_string($from_id)."'");
        sendMessage($from_id,"👁این پیش‌نمایش پست شماست.\nبرای ارسال هم‌اکنون، دکمه تایید  و برای زمانبندی ارسال، دکمه ذخیره را بزنید.","html",$channel_post_keyboard);
    } else {
        // اگر ارسال پیش‌نمایش با خطا مواجه شد، بهتر است رکورد پست را حذف کنیم تا به هم نریزد
        $db->query("DELETE FROM `votes` WHERE `id` = $post_id AND `record_type` = 'post'");
        $db->query("UPDATE `user` SET `step`='none',`getFile`=NULL WHERE `from_id`='".$db->real_escape_string($from_id)."'");
        sendMessage($from_id,"❌ خطا در ارسال پیش‌نمایش. دوباره تلاش کنید.", "html", $menuButtonsKeyboard);
    }
    return;
}

// ==================== 6) تایید نهایی و ارسال به کانال + حذف دکمهٔ تأیید از پیش‌نمایش ====================
$user = fetchUser($db,$from_id);
if ($isCallback && preg_match('/^confirm_post_(\d+)$/', $data, $m) && $is_owner) {
    $post_id = (int)$m[1];
    $post = mysqli_fetch_assoc($db->query("SELECT post_type,post_file_id,post_caption,post_channel_id,post_channel_username,post_inline_keyboard FROM votes WHERE id=$post_id AND record_type='post'"));
    if (!$post || empty($post['post_inline_keyboard'])) {
        answercallbackquery($callback_query_id, "❌ خطا: پست یا دکمه‌ها پیدا نشد.", true);
        return;
    }

    $inline_keyboard = json_decode($post['post_inline_keyboard'], true);
    if (!is_array($inline_keyboard)) {
        answercallbackquery($callback_query_id, "❌ خطا در پردازش دکمه‌ها.", true);
        return;
    }

    // انتخاب chat_id برای ارسال
    $chat_to_send = $post['post_channel_id'];
    // fallback: اگر به هر دلیل مقدار عددی خالی بود ولی username ذخیره شده بود
    if (empty($chat_to_send) && !empty($post['post_channel_username'])) {
        $chat_to_send = $post['post_channel_username'];
    }

    // ارسال به کانال
    $method = 'sendMessage';
    $params = [
        'chat_id' => $chat_to_send,
        'parse_mode' => 'html',
        'reply_markup' => json_encode(['inline_keyboard' => $inline_keyboard], JSON_UNESCAPED_UNICODE)
    ];
    if ($post['post_type'] !== 'text') {
        $ptype = $post['post_type'];
        $params[$ptype] = $post['post_file_id'];
        $params['caption'] = $post['post_caption'];
        $method = 'send' . ucfirst($ptype);
    } else {
        $params['text'] = $post['post_caption'];
    }

    $r = BoFile($method, $params);
    if ($r && isset($r->ok) && $r->ok) {
        // ذخیره message_id کانال (اختیاری ولی مفید)
        $mid = $r->result->message_id ?? null;
        if ($mid) {
            $db->query("UPDATE votes SET post_channel_message_id = " . (int)$mid . " WHERE id=$post_id AND record_type='post'");
        }

// حالا دکمهٔ "تأیید می‌کنم" + همه دکمه‌های پست را از پیش‌نمایش حذف می‌کنیم.
$preview_message = $update->callback_query->message ?? null;
if ($preview_message) {
    BoFile('editMessageReplyMarkup', [
        'chat_id' => $preview_message->chat->id,
        'message_id' => $preview_message->message_id,
        // این خط باعث میشه تمام inline keyboard ها پاک بشن
        'reply_markup' => json_encode(['inline_keyboard' => []], JSON_UNESCAPED_UNICODE)
    ]);
}





        $db->query("UPDATE `user` SET `step`='none',`getFile`=NULL WHERE `from_id`='".$db->real_escape_string($from_id)."'");
        sendMessage($from_id,"✅ پست با موفقیت به کانال ارسال شد.", "html", $menuButtonsKeyboard);
        answercallbackquery($callback_query_id, "✅ پست ارسال شد.", true);
    } else {
        answercallbackquery($callback_query_id, "❌ خطا در ارسال پست به کانال.", true);
    }
    return;
}

// ذخیره برای زمان‌بندی (ارسال نشود؛ فقط منتظر شو تا پستِ schedule در کانال منتشر شود)
if ($isCallback && preg_match('/^schedule_post_(\d+)$/', $data, $m) && $is_owner) {
    $post_id = (int)$m[1];
    $post = mysqli_fetch_assoc($db->query("SELECT post_inline_keyboard, post_caption, post_channel_id 
                                           FROM votes 
                                           WHERE id=$post_id AND record_type='post'"));
    if (!$post || empty($post['post_inline_keyboard']) || empty($post['post_channel_id'])) {
        answercallbackquery($callback_query_id, "❌ پست/دکمه/کانال نامعتبر است.", true);
        return;
    }

    // فعال‌سازی حالت انتظارِ چسباندن خودکار
    $db->query("UPDATE votes 
                SET post_autoattach_pending=1, post_autoattach_done=0 
                WHERE id=$post_id AND record_type='post'");

    // پیش‌نمایش را از حالت تایید خارج کن (فقط همان کیبورد تعریف‌شده نمایش داده شود)
$preview_message = $update->callback_query->message ?? null;
if ($preview_message) {
    BoFile('editMessageReplyMarkup', [
        'chat_id' => $preview_message->chat->id,
        'message_id' => $preview_message->message_id,
        // این خط باعث میشه تمام inline keyboard ها پاک بشن
        'reply_markup' => json_encode(['inline_keyboard' => []], JSON_UNESCAPED_UNICODE)
    ]);
}




    answercallbackquery($callback_query_id, "💾 ذخیره شد. پست را در کانال زمان‌بندی کن؛ هنگام انتشار، دکمه‌ها خودکار چسبانده می‌شوند.", true);
sendMessage(
    $from_id,
    "توجه: *نوع رسانه* و *کپشن* باید با پیش‌نمایش یکسان باشد تا ربات آن را تشخیص دهد⚠️",
    "Markdown",
    $menuButtonsKeyboard
);

    return;
}

// ==================== 7) رأی‌گیری (callback) ====================
// ================= هندلر رأی‌گیری =================
if ($isCallback && preg_match('/^vote_emoji_(\d+)_([A-Za-z0-9\-_]+)$/', $data, $m)) {
    $post_id = (int)$m[1];
    $encoded = $m[2];
    $emoji = base64url_decode($encoded);
    $emoji_safe = $db->real_escape_string($emoji);

    // گرفتن username از کاربر
    $username = array_key_exists('username', $from) ? $from['username'] : null;
    $username_safe = $username !== null && $username !== '' 
        ? "'" . $db->real_escape_string($username) . "'" 
        : "NULL";

    // گرفتن اطلاعات پست
    $post = mysqli_fetch_assoc($db->query("SELECT post_inline_keyboard, post_channel_id, post_channel_username, post_channel_message_id 
                                           FROM votes 
                                           WHERE id=$post_id AND record_type='post'"));
if ($post && empty($post['post_channel_username']) && $chat_username) {
    $db->query("UPDATE votes 
                SET post_channel_username='".$db->real_escape_string($chat_username)."' 
                WHERE id=".$post_id." AND record_type='post'");
}

    if (!$post) {
        answercallbackquery($callback_query_id, "❌ پست یافت نشد.", true);
        return;
    }

    // بررسی رأی قبلی
    $chk = $db->query("SELECT id FROM votes 
                       WHERE post_id=$post_id 
                         AND user_id='".$db->real_escape_string($from_id)."' 
                         AND record_type='vote' 
                       LIMIT 1");
    if ($chk && mysqli_num_rows($chk) > 0) {
        answercallbackquery($callback_query_id, "ℹ️ رأی شما قبلاً ثبت شده.", true);
        return;
    }

    // اطلاعات پیام/کانال از کال‌بک
    $message       = $update->callback_query->message ?? null;
    $chat_id       = $message->chat->id ?? null;
    $msg_id        = $message->message_id ?? null;
    $chat_username = isset($message->chat->username) && $message->chat->username
        ? '@' . $message->chat->username
        : null;

    // fallback از رکورد پست
    if (!$chat_id || !$msg_id) {
        $chat_id       = $chat_id ?: $post['post_channel_id'];
        $chat_username = $chat_username ?: $post['post_channel_username'];
        $msg_id        = $msg_id ?: (int)$post['post_channel_message_id'];
    }

    // آماده‌سازی برای SQL
    $chat_id_sql       = $chat_id !== null && $chat_id !== '' ? "'".$db->real_escape_string((string)$chat_id)."'" : "NULL";
    $chat_username_sql = $chat_username !== null && $chat_username !== '' ? "'".$db->real_escape_string($chat_username)."'" : "NULL";
    $msg_id_sql        = $msg_id ? (int)$msg_id : "NULL";

    // درج رأی (با اضافه کردن اطلاعات کانال و پیام)
    $ins = $db->query("INSERT INTO votes 
        (record_type, post_id, user_id, emoji, username, post_channel_id, post_channel_message_id, post_channel_username) 
        VALUES 
        ('vote',$post_id,'".$db->real_escape_string($from_id)."','".$emoji_safe."', $username_safe, $chat_id_sql, $msg_id_sql, $chat_username_sql)");
    if (!$ins) {
        if ($db->errno == 1062) {
            answercallbackquery($callback_query_id, "ℹ️ رأی شما قبلاً ثبت شده.", true);
        } else {
            answercallbackquery($callback_query_id, "❌ خطا در ثبت رأی.", true);
        }
        return;
    }

    // به‌روزرسانی شمارنده روی دکمه
    $inline_keyboard = json_decode($post['post_inline_keyboard'], true);
    if (!is_array($inline_keyboard)) {
        answercallbackquery($callback_query_id, "❌ دکمه‌ها نامعتبرند.", true);
        return;
    }

    $target = "vote_emoji_{$post_id}_{$encoded}";
    $updated = false;
    foreach ($inline_keyboard as &$row) {
        foreach ($row as &$btn) {
            if (isset($btn['callback_data']) && $btn['callback_data'] === $target) {
                if (preg_match('/^(.*\S)\s+(\d+)$/u', $btn['text'], $mm)) {
                    $btn['text'] = $mm[1] . ' ' . ((int)$mm[2] + 1);
                } else {
                    $btn['text'] = trim($emoji) . ' 1';
                }
                $updated = true;
                break 2;
            }
        }
    }

    if ($updated) {
        $message = $update->callback_query->message;
        $edit = BoFile('editMessageReplyMarkup', [
            'chat_id' => $message->chat->id,
            'message_id' => $message->message_id,
            'reply_markup' => json_encode(['inline_keyboard' => $inline_keyboard], JSON_UNESCAPED_UNICODE)
        ]);
        if ($edit && isset($edit->ok) && $edit->ok) {
            $db->query("UPDATE votes 
                        SET post_inline_keyboard = '" . $db->real_escape_string(json_encode($inline_keyboard, JSON_UNESCAPED_UNICODE)) . "' 
                        WHERE id=$post_id AND record_type='post'");
            answercallbackquery($callback_query_id, "✅ رأی شما ثبت شد!", true);
        } else {
            answercallbackquery($callback_query_id, "❌ خطا در به‌روزرسانی دکمه!", true);
        }
    } else {
        answercallbackquery($callback_query_id, "❌ دکمه یافت نشد!", true);
    }
    return;
}



// ==================== پایان ====================

// شروع فرآیند حذف دکمه‌های شیشه‌ای از یک پست کانال
if ($text === "🗑 حذف دکمه‌های شیشه‌ای از پست" && $is_owner) {
    $db->query("UPDATE `user` SET `step`='remove_buttons_wait' WHERE `from_id`='".$db->real_escape_string($from_id)."'");
    $msg = "🗑 لطفاً یکی از این کارها را انجام دهید:\n"
         . "• همان پست کانال را به اینجا فوروارد کنید.\n"
         . "• یا لینک پیام را بفرستید (عمومی یا خصوصی).\n"
         . "• یا آیدی داخلی پست (post_id) را بنویسید.\n\n"
         . "برای انصراف: «🔙 بازگشت»";
    // از همون کیبورد back که داری استفاده کن (channel_post_keyboard)
    sendMessage($from_id, $msg, "html", $channel_post_keyboard);
    return;
}


// ---- توابع کمکی (فقط در صورت عدم وجود تعریف) ----
if (!function_exists('parseTelegramMessageLink')) {
    function parseTelegramMessageLink($text) {
        $text = trim((string)$text);
        $text = preg_replace('~\?.*$~', '', $text);
        if (preg_match('~t\.me/(?:c/)(\d+)/(\d+)~i', $text, $m)) {
            $internal = $m[1];
            $msg_id   = (int)$m[2];
            $chat_id  = "-100" . $internal;
            return ['chat_id' => $chat_id, 'message_id' => $msg_id];
        }
        if (preg_match('~t\.me/([A-Za-z0-9_]+)/(\d+)~', $text, $m)) {
            $username = '@' . $m[1];
            $msg_id   = (int)$m[2];
            $r = BoFile('getChat', ['chat_id' => $username]);
            if ($r && isset($r->ok) && $r->ok && isset($r->result->id)) {
                return ['chat_id' => $r->result->id, 'message_id' => $msg_id];
            }
        }
        return null;
    }
}

if (!function_exists('removeInlineKeyboardByChatMsg')) {
    function removeInlineKeyboardByChatMsg($chat_id, $message_id) {
        return BoFile('editMessageReplyMarkup', [
            'chat_id'      => $chat_id,
            'message_id'   => $message_id,
            'reply_markup' => json_encode(['inline_keyboard' => []], JSON_UNESCAPED_UNICODE)
        ]);
    }
}

// helper: اجرای prepared statement و گرفتن همه ردیف‌ها (سازگار با سرورهای بدون mysqlnd)
if (!function_exists('fetchAllPrepared')) {
    function fetchAllPrepared(mysqli_stmt $stmt) {
        $resultRows = [];
        $stmt->execute();
        if ($stmt->errno) return $resultRows; // تغییر جدید: چک زودتر برای خطا

        // اگر get_result موجود است از آن استفاده کن
        if (method_exists($stmt, 'get_result')) {
            $res = $stmt->get_result();
            if ($res !== false) {
                while ($r = $res->fetch_assoc()) $resultRows[] = $r;
                return $resultRows;
            }
        }

        // fallback: bind_result dynamic
        $meta = $stmt->result_metadata();
        if (!$meta) return $resultRows;
        $fields = $meta->fetch_fields();
        $row = [];
        $bindParams = [];
        foreach ($fields as $f) {
            $row[$f->name] = null;
            $bindParams[] = & $row[$f->name];
        }
        if (!call_user_func_array([$stmt, 'bind_result'], $bindParams)) return $resultRows; // تغییر جدید: چک bind
        while ($stmt->fetch()) {
            if ($stmt->errno) break; // تغییر جدید: چک در loop
            $r = [];
            foreach ($row as $k => $v) $r[$k] = $v;
            $resultRows[] = $r;
        }
        return $resultRows;
    }
}

// تابع اصلی: پیدا کردن idهای رکورد post و حذف کامل رکوردهای مرتبط
if (!function_exists('delete_votes_for_post_resilient')) {
    function delete_votes_for_post_resilient(mysqli $db, $chat_id, int $message_id) {
        $chat_id = (string)$chat_id;
        $message_id = (int)$message_id;
        $debug = [
            'candidates' => [],
            'method' => null,
            'found_post_ids' => [],
            'sample_rows' => [],
            'sql_errors' => []
        ];
        $deleted = 0;

        // ساخت مجموعه کاندیدهای chat_id با انواع فرمت‌ها
        $candidates = [];
        $c = trim($chat_id);
        if ($c !== '') $candidates[] = $c;
        // اگر با -100 شروع می‌شود، بدون آن هم امتحان کن
        if (preg_match('/^-100(\d+)$/', $c, $m)) {
            $candidates[] = $m[1];            // بدون -100
            $candidates[] = '@' . $m[1];
        } else {
            // اگر فقط عدد است، نسخه با -100 را اضافه کن
            if (preg_match('/^\d+$/', $c)) {
                $candidates[] = '-100' . $c;
            }
            // ورژن با @username (در صورتی که username باشد)
            if (preg_match('/^[A-Za-z0-9_]+$/', $c)) {
                $candidates[] = '@' . $c;
            }
        }
        // پاکسازی و یکتا کردن
        $candidates = array_values(array_unique(array_filter($candidates, function($v){ return $v !== null && $v !== ''; })));
        $debug['candidates'] = $candidates;

        // helper برای خطاها
        $checkError = function() use ($db, &$debug) {
            if ($db->errno) {
                $debug['sql_errors'][] = $db->error . " (errno: {$db->errno})";
                return $db->error;
            }
            return false;
        };

        // شروع تراکنش
        if (method_exists($db, 'begin_transaction')) {
            $db->begin_transaction();
        } else {
            $db->query("START TRANSACTION");
        }

        try {
            // 1) تلاش برای پیدا کردن رکوردهای post با هر candidate
            $postIds = [];
            $ps = $db->prepare("SELECT id FROM votes WHERE record_type='post' AND post_channel_id=? AND post_channel_message_id=?");
            if ($ps) {
                foreach ($candidates as $cand) {
                    $ps->bind_param('si', $cand, $message_id);
                    $rows = fetchAllPrepared($ps);
                    if (!empty($rows)) {
                        foreach ($rows as $r) $postIds[] = (int)$r['id'];
                        $debug['method'] = 'exact_channel+message';
                        break;
                    }
                }
                $ps->close();
            } else {
                // اگر prepare نشد، fallback به query ساده برای اولین candidate
                foreach ($candidates as $cand) {
                    $esc = $db->real_escape_string($cand);
                    $q = $db->query("SELECT id FROM votes WHERE record_type='post' AND post_channel_id='$esc' AND post_channel_message_id=$message_id");
                    if ($q && $q->num_rows) {
                        while ($r = $q->fetch_assoc()) $postIds[] = (int)$r['id'];
                        $debug['method'] = 'exact_channel+message(fallback_query)';
                        break;
                    }
                }
            }

            // 2) اگر هنوز پیدا نشد: تلاش فقط با message_id (بدون channel)
            if (empty($postIds)) {
                $ps2 = $db->prepare("SELECT id FROM votes WHERE record_type='post' AND post_channel_message_id=?");
                if ($ps2) {
                    $ps2->bind_param('i', $message_id);
                    $rows2 = fetchAllPrepared($ps2);
                    foreach ($rows2 as $r) $postIds[] = (int)$r['id'];
                    if (!empty($rows2)) $debug['method'] = 'message_only_post';
                    $ps2->close();
                } else {
                    $q2 = $db->query("SELECT id FROM votes WHERE record_type='post' AND post_channel_message_id=$message_id");
                    if ($q2 && $q2->num_rows) {
                        while ($r = $q2->fetch_assoc()) $postIds[] = (int)$r['id'];
                        $debug['method'] = 'message_only_post(fallback_query)';
                    }
                }
            }

            // 3) اگر هنوز یافت نشد: نمونه‌ای از هر رکوردی که post_channel_message_id = message_id دارد را برای دیباگ بیاور
            if (empty($postIds)) {
                $ps3 = $db->prepare("SELECT id, record_type, post_channel_id, post_channel_message_id, post_id FROM votes WHERE post_channel_message_id=? LIMIT 50");
                if ($ps3) {
                    $ps3->bind_param('i', $message_id);
                    $rows3 = fetchAllPrepared($ps3);
                    $debug['sample_rows'] = $rows3;
                    if (!empty($rows3)) $debug['method'] = 'sample_rows_by_message';
                    $ps3->close();
                } else {
                    $q3 = $db->query("SELECT id, record_type, post_channel_id, post_channel_message_id, post_id FROM votes WHERE post_channel_message_id=$message_id LIMIT 50");
                    if ($q3 && $q3->num_rows) {
                        while ($r = $q3->fetch_assoc()) $debug['sample_rows'][] = $r;
                        $debug['method'] = 'sample_rows_by_message(fallback_query)';
                    }
                }
            }

            // اکنون: اگر postIds پیدا شد => حذف votes (رکوردهای vote که post_id اشاره می‌کنند) و حذف postها
            if (!empty($postIds)) {
                $idsCsv = implode(',', array_map('intval', $postIds));

                // حذف voteها
                $db->query("DELETE FROM votes WHERE record_type='vote' AND post_id IN ($idsCsv)");
                $err = $checkError();
                if ($err !== false) throw new Exception($err);
                $deleted += max(0, $db->affected_rows);

                // حذف رکوردهای post
                $db->query("DELETE FROM votes WHERE record_type='post' AND id IN ($idsCsv)");
                $err = $checkError();
                if ($err !== false) throw new Exception($err);
                $deleted += max(0, $db->affected_rows);

                // تغییر جدید: حذف هر رکورد vote دیگری که مستقیم با channel+message ذخیره شده (برای کامل بودن)
                foreach ($candidates as $cand) {
                    $escCand = $db->real_escape_string($cand);
                    $db->query("DELETE FROM votes WHERE record_type='vote' AND post_channel_id='$escCand' AND post_channel_message_id=$message_id AND (post_id IS NULL OR post_id NOT IN ($idsCsv))");
                    $err = $checkError();
                    if ($err !== false) throw new Exception($err);
                    $deleted += max(0, $db->affected_rows);
                }

            } else {
                // هیچ post id دقیقی یافت نشد؛ اگر sample_rows وجود دارد => حذف فقط voteها بر اساس post_channel_message_id و candidates (fallback ایمن‌تر)
                if (!empty($debug['sample_rows'])) {
                    foreach ($candidates as $cand) {
                        $escCand = $db->real_escape_string($cand);
                        $db->query("DELETE FROM votes WHERE record_type='vote' AND post_channel_id='$escCand' AND post_channel_message_id=$message_id");
                        $err = $checkError();
                        if ($err !== false) throw new Exception($err);
                        $deleted += max(0, $db->affected_rows);
                    }
                    $debug['method'] = $debug['method'] . ' -> fallback_delete_votes_only_by_message';
                } else {
                    // هیچ رکوردی پیدا نشد
                    $debug['method'] = $debug['method'] ?? 'not_found_any';
                }
            }

            // commit
            if (method_exists($db, 'commit')) $db->commit();
            else $db->query("COMMIT");

            $debug['found_post_ids'] = $postIds;
            return ['status' => 'ok', 'deleted' => $deleted, 'debug' => $debug];

        } catch (Exception $e) {
            // rollback
            if (method_exists($db, 'rollback')) $db->rollback();
            else $db->query("ROLLBACK");
            $debug['sql_errors'][] = $e->getMessage();
            return ['status' => 'error', 'error' => $e->getMessage(), 'debug' => $debug];
        }
    }
}

// ----------------- بلوک اصلی: زمانی که کاربر در حالت remove_buttons_wait است -----------------
$user = fetchUser($db, $from_id);
if ($user && isset($user['step']) && $user['step'] === 'remove_buttons_wait' && $is_owner) {
    if (isset($text) && trim($text) === "برگشت ←") {
        $db->query("UPDATE `user` SET `step`='none' WHERE `from_id`='".$db->real_escape_string($from_id)."'");
        sendMessage($from_id, "↩️ برگشتید.", "html", $panel);
        return;
    }

    // تعیین chat_id و message_id
    $chat_id = null;
    $message_id = null;

    // 1) اگر فوروارد از کانال ارسال شده
    if (isset($update->message->forward_from_chat) && isset($update->message->forward_from_message_id)) {
        $chat_id = $update->message->forward_from_chat->id;
        $message_id = $update->message->forward_from_message_id;
    } else {
        $raw = trim((string)($text ?? ''));
        if ($raw !== '') {
            $parsed = parseTelegramMessageLink($raw);
            if ($parsed) {
                $chat_id = $parsed['chat_id'];
                $message_id = $parsed['message_id'];
            } else {
                // شاید user یک post_id داخلی داده باشد (id رکورد post در جدول votes)
                if (preg_match('/^\d+$/', $raw)) {
                    $pid = (int)$raw;
                    $q = $db->query("SELECT post_channel_id, post_channel_message_id FROM votes WHERE id=$pid AND record_type='post' LIMIT 1");
                    if ($q && $row = $q->fetch_assoc()) {
                        if (!empty($row['post_channel_id']) && !empty($row['post_channel_message_id'])) {
                            $chat_id = $row['post_channel_id'];
                            $message_id = (int)$row['post_channel_message_id'];
                        }
                    }
                }
            }
        }
    }

    if (!$chat_id || !$message_id) {
        sendMessage($from_id, "❌ ورودی معتبر نبود. لطفاً پست را فوروارد کنید یا لینک/آیدی معتبر بدهید.", "html", $channel_post_keyboard);
        return;
    }

    // حذف کیبورد از تلگرام
    $r = removeInlineKeyboardByChatMsg($chat_id, $message_id);
    if (!($r && isset($r->ok) && $r->ok)) {
        sendMessage($from_id, "❌ خطا در حذف دکمه‌ها از پیام. مطمئن شوید ربات در کانال ادمین است و پیام را ربات ارسال کرده.", "html", $channel_post_keyboard);
        return;
    }

    // پاکسازی دیتابیس با تابع مقاوم
    $res = delete_votes_for_post_resilient($db, $chat_id, (int)$message_id);

    // خروج از حالت
    $db->query("UPDATE `user` SET `step`='none' WHERE `from_id`='".$db->real_escape_string($from_id)."'");

    // آماده‌سازی پیام نتیجه با اطلاعات دیباگ کوتاه
    if (!is_array($res) || !isset($res['status'])) {
        sendMessage($from_id, "⚠️ خطای غیرمنتظره هنگام پاکسازی رخ داد.", "html", $menuButtonsKeyboard);
        return;
    }
    if ($res['status'] === 'error') {
        $dbg = $res['debug'];
        $note = "⚠️ دکمه‌ها حذف شدند اما در حذف اطلاعات votes خطایی رخ داد:\n".$res['error'];
        // ضمیمه‌ی چند خط دیباگ مفید
        $note .= "\n\n🔎 دیباگ: روش جستجو: ".$dbg['method']."\nکاندیدها: ".implode(',', $dbg['candidates']);
        if (!empty($dbg['sample_rows'])) {
            $note .= "\nنمونه ردیف‌ها (تا 20):";
            $count = 0;
            foreach ($dbg['sample_rows'] as $r) {
                $count++;
                if ($count > 10) break;
                $note .= "\n- id:".$r['id']." type:".$r['record_type']." post_channel_id:".($r['post_channel_id'] ?? 'NULL')." post_id:".($r['post_id'] ?? 'NULL');
            }
        }
        sendMessage($from_id, "✅ دکمه‌ها حذف شدند.\n$note", "html", $menuButtonsKeyboard);
        return;
    }

    // موفقیت
    $dbg = $res['debug'];
    if ($res['deleted'] > 0) {
        $msg = "✅ دکمه‌ها حذف شدند.\n🧹 {$res['deleted']} ردیف از جدول votes پاک شد.\n🔎 روش جستجو: ".$dbg['method'];
        sendMessage($from_id, $msg, "html", $menuButtonsKeyboard);
    } else {
        // هیچ ردیفی پاک نشده — گزارش دیباگ برای بررسی
        $msg = "✅ دکمه‌ها حذف شدند.\nℹ️ اما هیچ رکوردی در جدول votes برای این پست پاک نشد.\n🔎 روش‌های جستجو: ".($dbg['method'] ?? 'none')."\nکاندیدهای chat_id که بررسی شد: ".implode(', ', $dbg['candidates']);
        if (!empty($dbg['sample_rows'])) {
            $msg .= "\nنمونه رکوردهای پیدا شده با post_channel_message_id (نشانه‌هایی دربارهٔ فرمت ذخیره‌شده):";
            $count = 0;
            foreach ($dbg['sample_rows'] as $r) {
                $count++;
                if ($count > 8) break;
                $msg .= "\n- id:".$r['id']." type:".$r['record_type']." post_channel_id:".($r['post_channel_id'] ?? 'NULL')." post_id:".($r['post_id'] ?? 'NULL');
            }
            $msg .= "\n(برای اطلاعات بیشتر، خروجی کامل نمونه‌ها را بفرست.)";
        } else {
            $msg .= "\n(هیچ رکوردی با آن message_id در جدول votes پیدا نشد.)";
        }
        sendMessage($from_id, $msg, "html", $menuButtonsKeyboard);
    }
    return;
}




// ------------------ 2) شروع فرآیند: کاربر روی "✏️ ویرایش پست" کلیک کرد ------------------
if ($text === "✏️ ویرایش دکمه‌های شیشه‌ای پست" && $is_owner) {
    $db->query("UPDATE `user` SET `step`='edit_buttons_wait' WHERE `from_id`='".$db->real_escape_string($from_id)."'");
    $msg = "✏️ لطفاً پست کانال را به من **فوروارد** کنید یا لینک پیام/آیدی داخلی را بفرستید.\n\n"
         . "بعد از فوروارد، از شما layout و سپس دادهٔ دکمه‌ها را می‌گیرم.\n\n"
         . "برای انصراف: «🔙 بازگشت»";
    sendMessage($from_id, $msg, "html", $channel_post_keyboard);
    return;
}

// ------------------ 3) دریافت پیام فوروارد / لینک / id و ذخیره متا ------------------
$user = fetchUser($db,$from_id);
if ($user && $user['step']==='edit_buttons_wait' && $is_owner) {
    if ($text === "برگشت ←") {
        $db->query("UPDATE `user` SET `step`='none' WHERE `from_id`='".$db->real_escape_string($from_id)."'");
        sendMessage($from_id,"↩️ برگشتید.","html",$menuButtonsKeyboard);
        return;
    }

    $chat_id = null; $message_id = null;

    // اگر فوروارد باشه
    if (isset($update->message->forward_from_chat) && isset($update->message->forward_from_message_id)) {
        $chat_id    = $update->message->forward_from_chat->id;
        $message_id = $update->message->forward_from_message_id;
    } else {
        // تلاش برای پارس لینک
        $raw = trim($text ?? '');
        $parsed = parseTelegramMessageLink($raw);
        if ($parsed) {
            $chat_id = $parsed['chat_id'];
            $message_id = $parsed['message_id'];
        } else {
            // شاید کاربر post_id داخلی داده (id در جدول votes)
            if (preg_match('/^\d+$/', $raw)) {
                $pid = (int)$raw;
                $row = mysqli_fetch_assoc($db->query("SELECT post_channel_id, post_channel_message_id FROM votes WHERE id=$pid AND record_type='post' LIMIT 1"));
                if ($row && !empty($row['post_channel_id']) && !empty($row['post_channel_message_id'])) {
                    $chat_id = $row['post_channel_id'];
                    $message_id = (int)$row['post_channel_message_id'];
                } else {
                    sendMessage($from_id, "❌ برای این post_id پیامی ثبت نشده یا message_id ذخیره نشده است. لطفاً خود پیام را فوروارد کنید.", "html", $channel_post_keyboard);
                    return;
                }
            } else {
                sendMessage($from_id, "❌ لطفاً پست را فوروارد کنید یا لینک/آیدی معتبر (مثال: https://t.me/ChannelName/123) ارسال کنید.", "html", $channel_post_keyboard);
                return;
            }
        }
    }

    if (!$chat_id || !$message_id) {
        sendMessage($from_id, "❌ ورودی معتبر نبود. لطفاً پست را فوروارد کنید یا لینک/آیدی معتبر بدهید.", "html", $channel_post_keyboard);
        return;
    }

    // ذخیرهٔ متا در فیلد getFile برای مراحل بعدی: فرمت => chat_id:message_id
    $meta = $db->real_escape_string($chat_id . ':' . (int)$message_id);
// ساخت متادیتا برای ذخیره: نوع/فایل/کپشن + یوزرنیم کانال
$metaType = 'text'; $metaFileId = ''; $metaCaption = ''; 
$metaUsername = getChannelUsernameById($chat_id);

// اگر کاربر پیام را فوروارد کرده، همین الان Message را داریم
if (isset($update->message->forward_from_chat) && isset($update->message->forward_from_message_id)) {
    list($metaType, $metaFileId, $metaCaption) = extractMessageMedia($update->message);
} else {
    // فقط لینک/آیدی داریم: یک فوروارد موقت به ادمین بزن تا Message را بگیریم
    $fw = BoFile('forwardMessage', [
        'chat_id' => $from_id,
        'from_chat_id' => $chat_id,
        'message_id' => $message_id
    ]);
    if ($fw && isset($fw->ok) && $fw->ok && isset($fw->result)) {
        list($metaType, $metaFileId, $metaCaption) = extractMessageMedia($fw->result);
        // اختیاری: پیام موقت را از چت ادمین پاک کن تا تمیز بماند
        BoFile('deleteMessage', ['chat_id' => $from_id, 'message_id' => $fw->result->message_id]);
    }
}

// بستهٔ متادیتا
$metaPack = json_encode([
    'type' => $metaType,
    'file_id' => $metaFileId,
    'caption' => $metaCaption,
    'channel_username' => $metaUsername
], JSON_UNESCAPED_UNICODE);

// حالا getFile را به شکل chat:msg|{metaJSON} ذخیره می‌کنیم
$gf = $db->real_escape_string($chat_id . ':' . (int)$message_id . '|' . $metaPack);
$db->query("UPDATE `user` SET `step`='edit_buttons_layout', `getFile`='$gf' WHERE `from_id`='".$db->real_escape_string($from_id)."'");


    sendMessage($from_id, "🔢 پست شناسایی شد. حالا layout جدید دکمه‌ها را خط‌به‌خط وارد کن (مثال:\n1 افقی\n2 عمودی\n3 افقی)", "html", $channel_post_keyboard);
    return;
}

// ------------------ 4) دریافت layout (مثل ارسال پست جدید) ------------------
$user = fetchUser($db,$from_id);
if ($user && $user['step']==='edit_buttons_layout' && $is_owner) {
    if ($text === "برگشت ←") {
        // پاک کردن متای موقت
        $db->query("UPDATE `user` SET `step`='none', `getFile`=NULL WHERE `from_id`='".$db->real_escape_string($from_id)."'");
        sendMessage($from_id,"↩️ برگشتید.","html",$menuButtonsKeyboard);
        return;
    }

    $raw = persianToEnglishDigits(trim($text));
    if ($raw === '') {
        sendMessage($from_id,"❌ لطفاً یک layout معتبر وارد کنید.", "html", $channel_post_keyboard);
        return;
    }

    $lines = array_filter(array_map('trim', explode("\n", $raw)));
    $layout = []; $totalButtons = 0;
    foreach ($lines as $ln) {
        $ln = trim($ln);
        if (preg_match('/^(\d+)\s*(افقی|عمودی)$/u', $ln, $m)) {
            $n = (int)$m[1]; $dir = $m[2];
        } elseif (preg_match('/^(افقی|عمودی)\s*(\d+)$/u', $ln, $m)) {
            $dir = $m[1]; $n = (int)$m[2];
        } else {
            sendMessage($from_id, "❌ فرمت هر خط باید مانند `1 افقی` یا `2 عمودی` باشد. خط مشکل‌دار: " . htmlspecialchars($ln), "html", $channel_post_keyboard);
            return;
        }
        if ($n <= 0) { sendMessage($from_id, "❌ تعداد باید بزرگتر از صفر باشد.", "html", $channel_post_keyboard); return; }
        $type = ($dir === 'افقی') ? 'horizontal' : 'vertical';
        $layout[] = ['type' => $type, 'count' => $n];
        $totalButtons += $n;
    }

    if ($totalButtons <= 0) {
        sendMessage($from_id, "❌ مجموع دکمه‌ها صفر است؛ لطفاً حداقل یک دکمه تعیین کنید.", "html", $channel_post_keyboard);
        return;
    }

    // append layout به getFile بصورت meta|json_layout
    $meta = $user['getFile']; // chat_id:message_id
$newGetFile = $db->real_escape_string(($user['getFile'] ?? '') . '|' . json_encode($layout, JSON_UNESCAPED_UNICODE));

    $db->query("UPDATE `user` SET `step`='edit_buttons_data', `getFile`='$newGetFile' WHERE `from_id`='".$db->real_escape_string($from_id)."'");

    sendMessage($from_id, "✏️ حالا دادهٔ هر دکمه را خط‌به‌خط وارد کن (مثلاً: `😀` یا `توضیح https://...`).\nباید دقیقاً $totalButtons دکمه وارد کنی.", "html", $channel_post_keyboard);
    return;
}

// ------------------ 5) گرفتن دادهٔ دکمه‌ها و اعمال تغییرات روی پست (ویرایش واقعی) ------------------
$user = fetchUser($db,$from_id);
if ($user && $user['step']==='edit_buttons_data' && $is_owner) {
    if ($text === "برگشت ←") {
        $db->query("UPDATE `user` SET `step`='none', `getFile`=NULL WHERE `from_id`='".$db->real_escape_string($from_id)."'");
        sendMessage($from_id,"↩️ برگشتید.","html",$menuButtonsKeyboard);
        return;
    }

    // خواندن meta و layout از getFile
$parts = explode('|', $user['getFile'] ?? '', 3);
if (count($parts) < 3) {
    sendMessage($from_id, "❌ خطا در داده‌های موقت؛ لطفاً دوباره از ابتدا تلاش کنید.", "html", $channel_post_keyboard);
    $db->query("UPDATE `user` SET `step`='none', `getFile`=NULL WHERE `from_id`='".$db->real_escape_string($from_id)."'");
    return;
}
list($chat_id, $message_id) = explode(':', $parts[0], 2);
$meta_json   = $parts[1];
$layout_json = $parts[2];

$chat_id    = $chat_id;
$message_id = (int)$message_id;
$layout     = json_decode($layout_json, true);
$metaArr    = json_decode($meta_json, true) ?: [];

$meta_type     = $metaArr['type'] ?? 'text';
$meta_file_id  = $metaArr['file_id'] ?? '';
$meta_caption  = $metaArr['caption'] ?? '';
$meta_username = $metaArr['channel_username'] ?? null;

    if (!is_array($layout)) {
        sendMessage($from_id, "❌ خطا در پردازش layout.", "html", $channel_post_keyboard);
        return;
    }

    // پیدا کردن رکورد پست در DB (در صورت وجود) — برای ساخت callback_data رأی‌گیری
    $post_row = mysqli_fetch_assoc($db->query(
        "SELECT id FROM votes WHERE post_channel_id='".$db->real_escape_string($chat_id)."' AND post_channel_message_id=".(int)$message_id." AND record_type='post' LIMIT 1"
    ));
    $post_id = $post_row ? (int)$post_row['id'] : 0;

    // اگر رکورد وجود نداشت، تلاش کنیم یک رکورد پست جدید بسازیم (برای داشتن post_id معتبر)
if ($post_id <= 0) {
    $ins_sql = "INSERT INTO votes 
        (record_type, post_type, post_file_id, post_caption, post_owner, post_channel_id, post_channel_message_id, post_channel_username, post_horizontal, post_vertical)
        VALUES 
        ('post',
         '".$db->real_escape_string($meta_type)."',
         '".$db->real_escape_string($meta_file_id)."',
         '".$db->real_escape_string($meta_caption)."',
         '".$db->real_escape_string($from_id)."',
         '".$db->real_escape_string($chat_id)."',
         ".(int)$message_id.",
         ".($meta_username ? "'".$db->real_escape_string($meta_username)."'" : "NULL").",
         0, 0)";
    $ok_ins = $db->query($ins_sql);
    if ($ok_ins) { $post_id = (int)$db->insert_id; }
    else {
        sendMessage($from_id, "⚠️ هشدار: رکورد پست ایجاد نشد؛ خطا: " . $db->error, "html", $channel_post_keyboard);
        $post_id = 0;
    }
}


    // پردازش ورودی دکمه‌ها (شبیه قبل) — ساخت buttonDefs
    $lines = array_filter(array_map('trim', explode("\n", $text)));
    $buttonDefs = [];
    foreach ($lines as $ln) {
        $parts = preg_split('/\s+/', $ln);
        if (count($parts) > 1 && filter_var(end($parts), FILTER_VALIDATE_URL)) {
            $url = array_pop($parts);
            $btn_text = trim(implode(' ', $parts));
            if ($btn_text === '') { sendMessage($from_id, "❌ متن دکمه برای لینک '$url' خالی است.", "html", $channel_post_keyboard); return; }
            $buttonDefs[] = ['text' => $btn_text, 'url' => $url];
        } else {
            // ایموجی‌ها یا متن‌های بدون لینک => callback_data با post_id فعلی بساز
            foreach ($parts as $p) {
                $p = trim($p);
                if ($p === '') continue;
                if ($post_id > 0) {
                    $enc = base64url_encode($p);
                    $buttonDefs[] = ['text' => $p . ' 0', 'callback_data' => "vote_emoji_{$post_id}_{$enc}"];
                } else {
                    // fallback: اگر post_id نداریم، دکمه بدون callback (فقط متن)
                    $buttonDefs[] = ['text' => $p];
                }
            }
        }
    }

    // شمارش کل دکمه‌ها از layout و بررسی تطابق
    $totalButtons = 0;
    foreach ($layout as $b) $totalButtons += (int)$b['count'];
    if (count($buttonDefs) !== $totalButtons) {
        sendMessage($from_id, "❌ تعداد دکمه‌ها نادرست است. بر اساس layout باید $totalButtons دکمه وارد کنید، ولی شما " . count($buttonDefs) . " وارد کردید.", "html", $channel_post_keyboard);
        return;
    }

    // ساخت inline_keyboard براساس layout
    $inline_keyboard = [];
    $idx = 0;
    foreach ($layout as $blk) {
        $cnt = (int)$blk['count'];
        if ($blk['type'] === 'horizontal') {
            $row = [];
            for ($i = 0; $i < $cnt; $i++) {
                $row[] = $buttonDefs[$idx++];
            }
            $inline_keyboard[] = $row;
        } else { // vertical
            for ($i = 0; $i < $cnt; $i++) {
                $inline_keyboard[] = [ $buttonDefs[$idx++] ];
            }
        }
    }

    // ویرایش reply_markup پیام کانال
    $edit = BoFile('editMessageReplyMarkup', [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'reply_markup' => json_encode(['inline_keyboard' => $inline_keyboard], JSON_UNESCAPED_UNICODE)
    ]);

    if ($edit && isset($edit->ok) && $edit->ok) {
        // اگر ویرایش تلگرام موفق بود => حالا داخل DB تراکنش انجام می‌دهیم:
        // 1) حذف تمام رأی‌های قدیمی مرتبط با این پست
        // 2) بروزرسانی رکورد post با inline_keyboard و layout/counts و message_id

        // آماده‌سازی داده‌ها برای ذخیره
        $inlineJsonEsc = $db->real_escape_string(json_encode($inline_keyboard, JSON_UNESCAPED_UNICODE));
        $layoutJsonEsc = $db->real_escape_string(json_encode($layout, JSON_UNESCAPED_UNICODE));
        $escChat = $db->real_escape_string($chat_id);

        // محاسبه مجموع افقی و عمودی (برای ستون‌های قدیمی‌تر)
        $sum_h = 0; $sum_v = 0;
        foreach ($layout as $blk) {
            if ($blk['type'] === 'horizontal') $sum_h += (int)$blk['count'];
            else $sum_v += (int)$blk['count'];
        }

        // شروع تراکنش
        if (method_exists($db, 'begin_transaction')) $db->begin_transaction();
        else $db->query("START TRANSACTION");

        try {
            // حذف همهٔ voteهای مرتبط (یک کوئری شامل هر دو حالتِ post_id و channel+message)
            if ($post_id > 0) {
                $delSql = "DELETE FROM votes
                           WHERE record_type='vote'
                             AND (post_id = " . (int)$post_id . " OR (post_channel_id = '$escChat' AND post_channel_message_id = " . (int)$message_id . "))";
            } else {
                $delSql = "DELETE FROM votes
                           WHERE record_type='vote'
                             AND post_channel_id = '$escChat' AND post_channel_message_id = " . (int)$message_id;
            }
            $db->query($delSql);
            if ($db->errno) throw new Exception($db->error);
            $deletedVotes = max(0, $db->affected_rows);

            // حالا آپدیت رکورد post (اگر داریم) با inline keyboard و layout و counts و message_id
            if ($post_id > 0) {
$updateParts = [];
$updateParts[] = "post_inline_keyboard = '$inlineJsonEsc'";
$updateParts[] = "post_channel_message_id = " . (int)$message_id;

if (columnExists($db, 'votes', 'post_layout')) {
    $updateParts[] = "post_layout = '$layoutJsonEsc'";
} else {
    $updateParts[] = "post_horizontal = " . (int)$sum_h;
    $updateParts[] = "post_vertical = " . (int)$sum_v;
}

// 🔴 چهار ستونی که قبلاً آپدیت نمی‌شدند:
$updateParts[] = "post_type = '".$db->real_escape_string($meta_type)."'";
$updateParts[] = "post_file_id = '".$db->real_escape_string($meta_file_id)."'";
$updateParts[] = "post_caption = '".$db->real_escape_string($meta_caption)."'";
$updateParts[] = "post_channel_username = ".($meta_username ? "'".$db->real_escape_string($meta_username)."'" : "NULL");

$updSql = "UPDATE votes SET " . implode(", ", $updateParts) . " WHERE id = " . (int)$post_id . " AND record_type='post'";
$db->query($updSql);
if ($db->errno) throw new Exception($db->error);

            } else {
                // اگر post_id واقعاً صفر است، تلاش می‌کنیم یک رکورد post به‌روز/ایجاد شده نگه داریم:
                // (در عمل قبلاً سعی کردیم insert کنیم، ولی اینجا حالت fallback است)
                // — هیچ به‌روزرسانی دیگری لازم نیست
            }

            // commit نهایی
            if (method_exists($db, 'commit')) $db->commit();
            else $db->query("COMMIT");

            // خروج از حالت و اطلاع‌رسانی
            $db->query("UPDATE `user` SET `step`='none', `getFile`=NULL WHERE `from_id`='".$db->real_escape_string($from_id)."'");

            if ($deletedVotes > 0) {
                sendMessage($from_id, "✅ دکمه‌های پست با موفقیت ویرایش شد.\n🧹 تعداد {$deletedVotes} رأیِ قدیمی پاک شد؛ کاربران اکنون می‌توانند دوباره رای دهند.", "html", $menuButtonsKeyboard);
            } else {
                sendMessage($from_id, "✅ دکمه‌های پست با موفقیت ویرایش شد.\nℹ️ رأی قدیمی‌ای برای این پست پیدا نشد (یا قبلاً حذف شده بودند).", "html", $menuButtonsKeyboard);
            }
        } catch (Exception $e) {
            // rollback و اطلاع‌رسانی خطا
            if (method_exists($db, 'rollback')) $db->rollback();
            else $db->query("ROLLBACK");

            $db->query("UPDATE `user` SET `step`='none', `getFile`=NULL WHERE `from_id`='".$db->real_escape_string($from_id)."'");
            sendMessage($from_id, "❌ خطا هنگام به‌روزرسانی رکوردها: " . htmlspecialchars($e->getMessage()), "html", $channel_post_keyboard);
        }
    } else {
        sendMessage($from_id, "❌ خطا در ویرایش دکمه‌ها (مستقیماً در کانال). مطمئن شوید ربات ادمین کانال است.", "html", $channel_post_keyboard);
    }
    return;
}