<?php
#======================= بخش مدیریت ارسال همگانی =======================#

$sendPanelKeyboard = json_encode([
    'keyboard' => [
        [ ['text' => "📪 ارسال به همه"], ['text' => "📪 فوروارد به همه"] ],
        [ ['text' => "🔘 تنظیم دکمه همگانی"], ['text' => "🗑 حذف دکمه همگانی"] ],
        [ ['text' => "برگشت 🔙"] ],
    ],
    'resize_keyboard' => true
], JSON_UNESCAPED_UNICODE);

// کیبورد موقت برای حالت ارسال به همه
$ajab_panel = json_encode([
    'keyboard' => [
        [['text' => "← برگشت"]]
    ],
    'resize_keyboard' => true
], JSON_UNESCAPED_UNICODE);

// تابع کمکی: تشخیص نوع پیام و ساخت payload برای ذخیره در دیتابیس
function buildBroadcastPayload(object $message): ?array {
    if (!empty($message->photo)) {
        $photo = end($message->photo);
        return ['type' => 'photo', 'file_id' => $photo->file_id, 'caption' => $message->caption ?? ''];
    }
    if (!empty($message->video)) {
        return ['type' => 'video', 'file_id' => $message->video->file_id, 'caption' => $message->caption ?? ''];
    }
    if (!empty($message->audio)) {
        return ['type' => 'audio', 'file_id' => $message->audio->file_id, 'caption' => $message->caption ?? ''];
    }
    if (!empty($message->voice)) {
        return ['type' => 'voice', 'file_id' => $message->voice->file_id, 'caption' => $message->caption ?? ''];
    }
    if (!empty($message->animation)) {
        return ['type' => 'animation', 'file_id' => $message->animation->file_id, 'caption' => $message->caption ?? ''];
    }
    if (!empty($message->document)) {
        return ['type' => 'document', 'file_id' => $message->document->file_id, 'caption' => $message->caption ?? ''];
    }
    if (!empty($message->sticker)) {
        return ['type' => 'sticker', 'file_id' => $message->sticker->file_id];
    }
    if (!empty($message->video_note)) {
        return ['type' => 'video_note', 'file_id' => $message->video_note->file_id];
    }
    if (!empty($message->text)) {
        return ['type' => 'text', 'text' => $message->text];
    }
    return null;
}

#======================= ورود به بخش ارسال پیام =======================#
if ($text == "📫 بخش ارسال پیام" && $from_id == $is_admin) {
    sendMessage($from_id, "📌 وارد بخش ارسال پیام شدید. گزینه مورد نظر را انتخاب کنید:", null, $sendPanelKeyboard, $message_id);
    $db->query("UPDATE `user` SET `step`='none' WHERE `from_id`='$from_id'");
}

#======================= ارسال به همه =======================#
elseif ($text == "📪 ارسال به همه" && $from_id == $is_admin) {
    sendMessage($from_id, "📤 هر نوع پیامی می‌توانید ارسال کنید (متن، عکس، ویدیو، ویس، موزیک، گیف، سند و ...):", null, $ajab_panel, $message_id);
    $db->query("UPDATE `user` SET `step`='sendAll' WHERE `from_id`='$from_id'");
}

elseif ($step == 'sendAll' && $text != "← برگشت") {
    $payload = buildBroadcastPayload($message);
    if (!$payload) {
        sendMessage($from_id, "❌ نوع پیام پشتیبانی نمی‌شود. لطفاً یکی از انواع مجاز را ارسال کنید.", null, $ajab_panel, $message_id);
        exit;
    }

    $countUsers = (int)(mysqli_fetch_assoc($db->query("SELECT COUNT(`row`) AS c FROM `user`"))['c'] ?? 0);
    $estimate = max(0.5, round($countUsers / 100));
    $statusMsgId = sendMessage($from_id, 
        "✅ پیام شما در صف ارسال قرار گرفت.\n👥 تعداد کاربران: $countUsers\n⏳ زمان تخمینی  : $estimate دقیقه", 
        "markdown", 
        json_encode([
            'inline_keyboard' => [
                [['text' => "📋 ارسال شده: 0", 'callback_data' => 'none']],
                [['text' => "⏳ زمان باقیمانده: $estimate", 'callback_data' =>     'none']],
                [['text' => "❌ انصراف", 'callback_data' => 'cancel_send']]
            ]
        ], JSON_UNESCAPED_UNICODE), 
        $message_id
    )->result->message_id;


    file_put_contents(__DIR__ . '/lib/msg.txt', $statusMsgId);
    file_put_contents(__DIR__ . '/lib/id.txt', $from_id);

    $json = $db->real_escape_string(json_encode($payload, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
    $db->query("UPDATE `user` SET `step`='none' WHERE `from_id`='$from_id'");
    $db->query("DELETE FROM `send` WHERE 1");
    $db->query("INSERT INTO `send`(`step`,`text`,`from`,`user`) VALUES ('send','$json','$from_id',0)");
    exit;
}
#======================= فوروارد به همه =======================#
elseif ($text == "📪 فوروارد به همه" && $from_id == $is_admin) {
    sendMessage($from_id, "📤 لطفاً پیام مورد نظر برای فوروارد را ارسال کنید:", null, $ajab_panel, $message_id);
    $db->query("UPDATE `user` SET `step`='forAll' WHERE `from_id`='$from_id'");
}

elseif ($step == 'forAll' && $text != "← برگشت") {
    $countUsers = (int)(mysqli_fetch_assoc($db->query("SELECT COUNT(`row`) AS c FROM `user`"))['c'] ?? 0);
    $estimate = max(0.5, round($countUsers / 100));

    $statusMsgId = sendMessage($from_id, 
        "✅ پیام شما برای فوروارد آماده شد.\n👥 تعداد کاربران: $countUsers", 
        null, 
        json_encode([
            'inline_keyboard' => [
                [['text' => "📋 ارسال شده: 0", 'callback_data' => 'none']],
                [['text' => "⏳ زمان باقیمانده: $estimate", 'callback_data' =>     'none']],
                [['text' => "❌ انصراف", 'callback_data' => 'cancel_send']]
            ]
        ], JSON_UNESCAPED_UNICODE), 
        $message_id
    )->result->message_id;


    file_put_contents(__DIR__ . '/lib/msg.txt', $statusMsgId);
    file_put_contents(__DIR__ . '/lib/id.txt', $from_id);

    $db->query("UPDATE `user` SET `step`='none' WHERE `from_id`='$from_id'");
    $db->query("DELETE FROM `send` WHERE 1");
    $db->query("INSERT INTO `send`(`step`,`text`,`from`,`user`) VALUES ('for','$message_id','$from_id',0)");
    exit;
}


#----------هدل دکمه انصراف ارسال پیام همگانی----------#

if ($data === "cancel_send") {
    // پاک کردن جدول send
    mysqli_query($db, "DELETE FROM `send`");
    mysqli_query($db, "ALTER TABLE `send` AUTO_INCREMENT = 1");

    // حذف پیام وضعیت اصلی
    deleteMessage($chat_id, $message_id);

    // ارسال پیام جدید با کیبورد
    sendMessage($chat_id, "❌ ارسال لغو شد", "html", $sendPanelKeyboard);

    // پاسخ به callback برای حذف لودینگ
    answercallbackquery($callback_id, "ارسال لغو شد ✅");
}
#======================= تنظیم دکمه همگانی پیشرفته =======================#
elseif ($text == "🔘 تنظیم دکمه همگانی" && $from_id == $is_admin) {
    sendMessage($from_id, "📌 لطفاً الگوی دکمه‌ها را وارد کنید.\nمثال:\n\n2 افقی\n1 عمودی\n2 افقی\n\nهر خط = تعداد دکمه و جهت (افقی/عمودی)", null, $ajab_panel, $message_id);
    $db->query("UPDATE `user` SET `step`='setLayout' WHERE `from_id`='$from_id'");
}
if ($text == "← برگشت" && $from_id == $is_admin) {
    $db->query("UPDATE user SET step = 'none', temp_user_id = NULL WHERE from_id = '$from_id'");
    sendMessage($from_id, "به منوی ارسال پیام برگشتید.", "html", $sendPanelKeyboard, $message_id);
}
elseif ($step == 'setLayout') {
    $lines = array_filter(array_map('trim', explode("\n", $text)));
    $layout = [];
    $totalButtons = 0;
    $valid = true;

    foreach ($lines as $line) {
        if (preg_match('/^(\d+)\s*(افقی|عمودی)$/u', $line, $m)) {
            $count = (int)$m[1];
            $dir = $m[2];
            if ($count > 0) {
                $layout[] = ['count'=>$count,'dir'=>$dir];
                $totalButtons += $count;
            }
        } else {
            $valid = false;
            break;
        }
    }

    if (!$valid || $totalButtons == 0) {
        sendMessage($from_id, "❌ فرمت اشتباه است. لطفاً دوباره ارسال کنید (مثال: 2 افقی یا 1 عمودی).", null, $ajab_panel, $message_id);
    } else {
        // ذخیره layout در فایل موقت
        file_put_contents(__DIR__ . '/layout.json', json_encode($layout, JSON_UNESCAPED_UNICODE));
        sendMessage($from_id, "✅ الگو ذخیره شد.\n📌 شما {$totalButtons} دکمه دارید.\nلطفاً اکنون {$totalButtons} خط محتوا برای دکمه‌ها بفرستید.\n\n📍فرمت:\n- دکمه لینک‌دار: متن لینک (در یک خط)\n- دکمه ساده: فقط متن", null, $ajabpanel, $message_id);
        file_put_contents(__DIR__ . '/total.txt', $totalButtons);
        $db->query("UPDATE `user` SET `step`='setButtons' WHERE `from_id`='$from_id'");
    }
}

elseif ($step == 'setButtons') {
    $expected = (int)@file_get_contents(__DIR__ . '/total.txt');
    $lines = array_filter(array_map('trim', explode("\n", $text)));

    if (count($lines) != $expected) {
        sendMessage($from_id, "❌ تعداد خطوط با تعداد دکمه‌ها برابر نیست (باید {$expected} خط باشد).", null, $ajab_panel, $message_id);
    } else {
        $layout = json_decode(@file_get_contents(__DIR__ . '/layout.json'), true);
        $buttons = [];
        $lineIndex = 0;

        foreach ($layout as $row) {
            $rowButtons = [];
            for ($i=0;$i<$row['count'];$i++) {
                $btnText = $lines[$lineIndex];
                $lineIndex++;
                // اگر خط شامل لینک باشد
                if (preg_match('/^(.+)\s+(https?:\/\/\S+)$/u', $btnText, $m)) {
                    $rowButtons[] = ['text'=>$m[1], 'url'=>$m[2]];
                } else {
                    $rowButtons[] = ['text'=>$btnText, 'callback_data'=>'noop'];
                }
            }
            $buttons[] = $rowButtons;
        }

        // ذخیره دکمه‌ها در فایل
        $inline = ['inline_keyboard'=>$buttons];
        file_put_contents(__DIR__ . '/buttons.json', json_encode($inline, JSON_UNESCAPED_UNICODE));

        sendMessage($from_id, "✅ دکمه‌ها با موفقیت ذخیره شدند. از این پس زیر پیام‌های همگانی نمایش داده می‌شوند.", null, $sendPanelKeyboard, $message_id);
        @unlink(__DIR__ . '/layout.json');
        @unlink(__DIR__ . '/total.txt');
        $db->query("UPDATE `user` SET `step`='none' WHERE `from_id`='$from_id'");
    }
}

#======================= حذف دکمه همگانی =======================#
elseif ($text == "🗑 حذف دکمه همگانی" && $from_id == $is_admin) {
    $file = __DIR__ . '/buttons.json';

    if (!file_exists($file)) {
        sendMessage($from_id, "❌ دکمه همگانی برای حذف وجود ندارد.");
    } else {
        @unlink($file);
        sendMessage($from_id, "🗑 دکمه‌های همگانی حذف شدند. از این پس پیام‌ها بدون دکمه ارسال می‌شوند.");
        $db->query("UPDATE `user` SET `step`='none' WHERE `from_id`='$from_id'");
    }
}
