<?php
// اگر کاربر روی "سفارش ربات" کلیک کرد
// کاربر دکمه "پشتیبانی ربات" رو زده
if (isset($message->text) && $message->text === '🤖 پشتیبانی ربات' && $user['step'] === 'none') {
    // نمایش دکمه‌های انتخاب
    $inlineKeyboard = [
        'inline_keyboard' => [
            [
                ['text' => "📝 شروع چت", 'callback_data' => "start_support"],
                ['text' => "❌ انصراف", 'callback_data' => "back_support"]
            ]
        ]
    ];

    sendMessage(
        $from_id,
        "⚠️ کاربر عزیز : 
دقت کن که اگر هر سوالی و حرفی راجب کانال ایران بالیوود داری، از طریق دکمه پشتیبانی ایران بالیوود اقدام کن.
اگر صرفا در مورد ربات، سفارش ربات مشابه و بهبود عملکردش پیشنهاد یا انتقادی داری دکمه شروع چت رو در پایین بزن.",
        "html",
        json_encode($inlineKeyboard)
    );

    exit;
}

// -------------------------
// هندل کردن کلیک روی دکمه‌های inline
if (isset($update->callback_query)) {
    $callbackData = $update->callback_query->data;
    $callbackChatId = $update->callback_query->message->chat->id;
    $callbackMessageId = $update->callback_query->message->message_id;

    if ($callbackData === "start_support") {
        // حذف پیام دکمه‌های قبلی
        deleteMessage($callbackChatId, $callbackMessageId);

        // ثبت state
        $db->query("INSERT INTO user_states (user_id, state) VALUES ('$callbackChatId', 'waiting_for_support_message') 
                    ON DUPLICATE KEY UPDATE state = 'waiting_for_support_message'");

        // ارسال پیام شروع چت با کیبورد پایان چت
        sendMessage(
            $callbackChatId,
            "هم اکنون می‌توانید پیام خود را به توسعه دهنده ارسال کنید.\n(پیام شما میتواند متن،ویس،تصویر یا ویدیو هم باشد)\nبرای اتمام مکالمه و بازگشت به منوی اصلی، دکمه پایان چت رو از پایین انتخاب کنید.",
            "html",
            getUserKeyboard($db, $callbackChatId)
        );

        // جواب به callback تا لودینگ دکمه تموم بشه
        answerCallbackQuery($update->callback_query->id, "چت پشتیبانی شروع شد ✅");
    }

    if ($callbackData === "back_support") {
        // حذف پیام و کیبورد
        deleteMessage($callbackChatId, $callbackMessageId);

        // جواب به callback
        answerCallbackQuery($update->callback_query->id, "بازگشت انجام شد 🔙");
    }
}





// اگر کاربر روی "پایان چت" کلیک کرد
if (isset($message->text) && $message->text === '🛑 پایان چت' && ($state === 'waiting_for_support_message' || $state === 'ongoing_support')) {
    // ریست state
    $db->query("UPDATE user_states SET state = '' WHERE user_id = '$from_id'");
    
    // ارسال پیام به کاربر
    $result = sendMessage(
        $from_id,
        'مکالمه با توسعه‌دهنده پایان یافت.
برای شروع مجدد، از دکمه "پشتیبانی ربات" استفاده کنید.',
        'html',
        getUserKeyboard($db, $from_id) // کیبورد عادی
    );
    
    // اطلاع به owner
    $display_name = getDisplayName($username, $from_id);
    sendMessage($owner, "کاربر $display_name چت را به پایان رساند.", 'html');
    
    exit;
}

// اگر owner روی "اتمام مکالمه" کلیک کرد
if ($from_id == $owner && isset($message->text) && $message->text === '🛑 اتمام مکالمه' && isset($message->reply_to_message)) {
    $reply_to_message_id = $message->reply_to_message->message_id;
    $mapping_query = $db->query("SELECT user_id FROM support_forwards WHERE owner_message_id = '$reply_to_message_id' LIMIT 1");
    if (mysqli_num_rows($mapping_query) > 0) {
        $mapping_row = mysqli_fetch_assoc($mapping_query);
        $target_user_id = $mapping_row['user_id'];
        
        // ریست state کاربر
        $db->query("UPDATE user_states SET state = '' WHERE user_id = '$target_user_id'");
        
        // ارسال پیام به کاربر
        $result = sendMessage(
            $target_user_id,
            'مکالمه توسط ادمین به اتمام رسید. در صورت نیاز مجدد به صحبت کردن و برقراری ارتباط، از دکمه "🤖 پشتیبانی ربات" استفاده کنید.',
            'html',
            getUserKeyboard($db, $target_user_id) // کیبورد عادی
        );
        
        // اطلاع به owner
        $display_name = getDisplayName($username, $target_user_id);
        sendMessage($owner, "مکالمه با کاربر $display_name پایان یافت.", 'html');
        
        exit;
    } else {
        sendMessage($owner, "کاربر مرتبط با این پیام پیدا نشد.", 'html');
        exit;
    }
}

// اگر کاربر در حالت مکالمه است و پیامی فرستاد
if (($state === 'waiting_for_support_message' || $state === 'ongoing_support') && isset($message)) {

    // فوروارد پیام به مالک
    $forward_result = ForwardMessage($owner, $from_id, $message->message_id);

    if ($forward_result && isset($forward_result->result->message_id)) {
        $owner_message_id = $forward_result->result->message_id;
        $db->query("INSERT INTO support_forwards (user_id, owner_message_id) VALUES ('$from_id', '$owner_message_id')");

        // ارسال پیام تکمیلی به مالک با اطلاعات کاربر + دکمه شیشه‌ای
        $user_info = "پیام جدید از کاربر:\nآیدی عددی: $from_id\nیوزرنیم: " . ($username ? "@$username" : 'ندارد');

        sendMessage(
            $owner,
            $user_info,
            'html',
            json_encode([
                'inline_keyboard' => [
                    [['text' => '🛑 اتمام مکالمه', 'callback_data' => 'end_chat_' . $from_id]]
                ]
            ])
        );
    }

    // پیام تأیید به کاربر
    sendMessage(
        $from_id,
        'پیام شما برای توسعه‌دهنده ارسال شد. برای پایان دادن به مکالمه، از دکمه "پایان چت" استفاده کنید.',
        'html',
        getUserKeyboard($db, $from_id)
    );

    // بروزرسانی state کاربر
    $db->query("UPDATE user_states SET state = 'ongoing_support' WHERE user_id = '$from_id'");
    exit;
}

// اگر مالک روی دکمه شیشه‌ای "اتمام مکالمه" کلیک کرد
if (isset($update->callback_query) && strpos($update->callback_query->data, 'end_chat_') === 0) {
    $target_user_id = str_replace('end_chat_', '', $update->callback_query->data);
    $callback_id = $update->callback_query->id;
    $chat_id = $update->callback_query->message->chat->id;

    // بررسی وضعیت مکالمه کاربر
    $state_query = $db->query("SELECT state FROM user_states WHERE user_id = '$target_user_id' LIMIT 1");
    $state = '';
    if (mysqli_num_rows($state_query) > 0) {
        $row = mysqli_fetch_assoc($state_query);
        $state = $row['state'];
    }

    if ($state === 'ongoing_support' || $state === 'waiting_for_support_message') {
        // مکالمه باز است → پایان بده
        $db->query("UPDATE user_states SET state = '' WHERE user_id = '$target_user_id'");

        // اطلاع به کاربر
        sendMessage(
            $target_user_id,
            'مکالمه توسط پشتیبانی به اتمام رسید. برای شروع مجدد، از دکمه "🤖 پشتیبانی ربات" استفاده کنید.',
            'html',
            getUserKeyboard($db, $target_user_id)
        );

        // اطلاع به مالک
        sendMessage($chat_id, "مکالمه با کاربر $target_user_id پایان یافت.", 'html');

        // پاسخ به Callback تا دکمه گیر نکند
        answerCallbackQuery($callback_id, "مکالمه پایان یافت");

    } else {
        // مکالمه از قبل بسته شده بود → فقط به مالک بگو
        answerCallbackQuery($callback_id, "این مکالمه از قبل بسته شده است.");
        sendMessage($chat_id, "مکالمه با کاربر $target_user_id قبلاً بسته شده بود.", 'html');
    }

    exit;
}



// اگر پیام از مالک باشد و ریپلای به یک پیام فوروارد‌شده باشد
if ($from_id == $owner && isset($message->reply_to_message)) {
    $reply_to_message_id = $message->reply_to_message->message_id;
    $mapping_query = $db->query("SELECT user_id FROM support_forwards WHERE owner_message_id = '$reply_to_message_id' LIMIT 1");

    if (mysqli_num_rows($mapping_query) > 0) {
        $mapping_row = mysqli_fetch_assoc($mapping_query);
        $target_user_id = $mapping_row['user_id'];

        // ارسال پیام مالک به کاربر
        if (isset($message->text)) {
            sendMessage($target_user_id, $message->text, 'html', getUserKeyboard($db, $target_user_id));
        } elseif (isset($message->photo)) {
            SendPhoto(
                $target_user_id,
                $message->photo[0]->file_id,
                isset($message->caption) ? $message->caption : '',
                null,
                'html',
                getUserKeyboard($db, $target_user_id)
            );
        } elseif (isset($message->video)) {
            BoFile('sendVideo', [
                'chat_id' => $target_user_id,
                'video' => $message->video->file_id,
                'caption' => isset($message->caption) ? $message->caption : '',
                'parse_mode' => 'html',
                'reply_markup' => getUserKeyboard($db, $target_user_id)
            ]);
        } elseif (isset($message->voice)) {
            sendVoice(
                $target_user_id,
                $message->voice->file_id,
                '',
                null,
                'html',
                getUserKeyboard($db, $target_user_id)
            );
        }

        // آپدیت state کاربر به حالت مکالمه فعال
        $db->query("INSERT INTO user_states (user_id, state) VALUES ('$target_user_id', 'ongoing_support') ON DUPLICATE KEY UPDATE state = 'ongoing_support'");

        // بلافاصله کیبورد کاربر را به حالت «فقط پایان چت» تغییر بده
sendMessage(
    $target_user_id,
    "‌", // ← این همون ZWSP هست (هیچ چیزی دیده نمیشه)
    json_encode([
        'keyboard' => [
            [['text' => "🛑 پایان چت"]]
        ],
        'resize_keyboard' => true
    ], JSON_UNESCAPED_UNICODE)
);



        // پیام تایید برای مالک
        sendMessage($owner, 'پیام شما به کاربر ارسال شد و کیبوردش به حالت مکالمه تغییر کرد.', 'html');

        exit;
    } else {
        sendMessage($owner, "کاربر مرتبط با این پیام پیدا نشد.", 'html');
        exit;
    }
}