<?php
#=============================# کپچا #=============================#
// ---------- Step 0: Parse Update ----------
$update = json_decode(file_get_contents('php://input'));

$from_id = null;
$message_id = null;
$text = null;
$data = null;
$callback_query_id = null;
$isCallback = false;

if (isset($update->callback_query)) {
    $isCallback = true;
    $callback_query_id = $update->callback_query->id ?? null;
    $from_id = $update->callback_query->from->id ?? null;
    $message_id = $update->callback_query->message->message_id ?? null;
    $data = $update->callback_query->data ?? null;
} elseif (isset($update->message)) {
    $from_id = $update->message->from->id ?? null;
    $message_id = $update->message->message_id ?? null;
    $text = $update->message->text ?? null;
}

// ---------- Step 1: sendCaptcha (with anti-duplicate guard) ----------
function sendCaptcha($from_id, $id) {
    global $db, $is_owner;

    // اگر ادمین بود، کپچا رو رد کن و فایل رو مستقیم بفرست
    if ($is_owner) {
        send($from_id, null, $id, 'send');
        // null کردن getFile بعد از موفقیت (فرض بر موفقیت send)
        $db->query("UPDATE `user` SET `getFile`=NULL WHERE `from_id`='{$from_id}'");
        return;
    }

    // ضدتکرار
    $chk = $db->query("SELECT `step`,`captcha_msg_id` FROM `user` WHERE `from_id`='{$from_id}' LIMIT 1");
    if ($chk && mysqli_num_rows($chk) > 0) {
        $u = mysqli_fetch_assoc($chk);
        if ($u['step'] === 'captcha' && !empty($u['captcha_msg_id'])) {
            return;
        }
    }

    // سوال تصادفی از DB
    $q = $db->query("SELECT * FROM `captcha_pool` ORDER BY RAND() LIMIT 1");
    if ($q && mysqli_num_rows($q) > 0) {
        $row = mysqli_fetch_assoc($q);
        $question      = $row['question'];
        $image_file_id = $row['image_file_id'] ?? null;
        $audio_file_id = $row['audio_file_id'] ?? null;

        // آماده‌سازی گزینه‌ها
        $opts = [
            ['text' => $row['option1'], 'ok' => ((int)$row['correct_option'] === 1)],
            ['text' => $row['option2'], 'ok' => ((int)$row['correct_option'] === 2)],
            ['text' => $row['option3'], 'ok' => ((int)$row['correct_option'] === 3)],
        ];
        shuffle($opts);

        $correctIndex = 1;
        foreach ($opts as $i => $o) {
            if ($o['ok']) {
                $correctIndex = $i+1;
                break;
            }
        }

        // ست کردن وضعیت کاربر
        $safeId = $db->real_escape_string($id);
        $db->query("UPDATE `user`
                        SET `step`='captcha',
                            `getFile`='{$safeId}',
                            `captcha_answer`='{$correctIndex}',
                            `captcha_attempts`=0,
                            `captcha_msg_id`=NULL,
                            `captcha_photo_msg_id`=NULL,
                            `captcha_audio_msg_id`=NULL
                    WHERE `from_id`='{$from_id}'");

        // کیبورد اینلاین
        $rowBtns = [];
        foreach ($opts as $i => $o) {
            $rowBtns[] = ['text' => $o['text'], 'callback_data' => "captcha_{$id}_".($i+1)];
        }
        $keyboard = json_encode(['inline_keyboard' => [ $rowBtns ]], JSON_UNESCAPED_UNICODE);

        // --- ارسال در پیام‌های جدا ---
        $photoMsgId = null;
        $audioMsgId = null;
        $replyToId = null;

        // 1) اول عکس (بدون کپشن و بدون کیبورد)
        if (!empty($image_file_id)) {
            $photoRes = SendPhoto($from_id, $image_file_id, '', '', '', '');
            $photoMsgId = $photoRes->result->message_id ?? null;
            if ($photoMsgId) {
                $db->query("UPDATE `user` SET `captcha_photo_msg_id`={$photoMsgId} WHERE `from_id`='{$from_id}'");
                $replyToId = $photoMsgId;
            }
        }

        // 2) سپس موزیک یا ویس (اگر وجود داشته باشد، بدون کپشن و بدون کیبورد)
        if (!empty($audio_file_id)) {
            // فرض می‌کنیم SendAudio برای موزیک/ویس استفاده می‌شود
            $audioRes = SendAudio($from_id, $audio_file_id, '', '', '', '');
            $audioMsgId = $audioRes->result->message_id ?? null;
            if ($audioMsgId) {
                $db->query("UPDATE `user` SET `captcha_audio_msg_id`={$audioMsgId} WHERE `from_id`='{$from_id}'");
                $replyToId = $audioMsgId;
            }
        }

        // 3) سپس سؤال + گزینه‌ها (این پیام را به‌عنوان captcha_msg ذخیره می‌کنیم)
        if ($replyToId) {
            $msgRes = sendMessage(
                $from_id,
                "🔐جهت دریافت فایل‌ها ابتدا کپچای زیر را حل کنید.\n────────────\n\n<b>{$question}</b>",
                "html",
                $keyboard,
                $replyToId
            );
        } else {
            $msgRes = sendMessage(
                $from_id,
                "🔐جهت دریافت فایل‌ها ابتدا کپچای زیر را حل کنید.\n────────────\n\n<b>{$question}</b>",
                "html",
                $keyboard
            );
        }


        $msgId  = $msgRes->result->message_id ?? null;
if ($msgId) {
    $db->query("UPDATE `user` SET `captcha_msg_id`={$msgId} WHERE `from_id`='{$from_id}'");
} else {
    // اگر به هر دلیلی ارسال متن Fail شد
}


    } else {
        // fallback ریاضی (DB خالی)
        $a = rand(1,10); $b = rand(1,10); $answer = $a + $b;
        $wrong1 = $answer + rand(-5,5); while ($wrong1 == $answer || $wrong1 < 0) $wrong1 = $answer + rand(-5,5);
        $wrong2 = $answer + rand(-5,5); while ($wrong2 == $answer || $wrong2 == $wrong1 || $wrong2 < 0) $wrong2 = $answer + rand(-5,5);
        $vals = [$answer,$wrong1,$wrong2]; shuffle($vals);

        $safeId = $db->real_escape_string($id);
        $db->query("UPDATE `user`
                        SET `step`='captcha',
                            `getFile`='{$safeId}',
                            `captcha_answer`='{$answer}',
                            `captcha_attempts`=0,
                            `captcha_msg_id`=NULL,
                            `captcha_photo_msg_id`=NULL,
                            `captcha_audio_msg_id`=NULL
                    WHERE `from_id`='{$from_id}'");

        $keyboard = json_encode([
            'inline_keyboard' => [[
                ['text'=>(string)$vals[0],'callback_data'=>"captcha_{$id}_{$vals[0]}"],
                ['text'=>(string)$vals[1],'callback_data'=>"captcha_{$id}_{$vals[1]}"],
                ['text'=>(string)$vals[2],'callback_data'=>"captcha_{$id}_{$vals[2]}"],
            ]]
        ], JSON_UNESCAPED_UNICODE);

        $res   = sendMessage($from_id, "🔐جهت دریافت فایل‌ها ابتدا کپچای زیر را حل کنید:\n\n$a + $b = ؟", "html", $keyboard);
        $msgId = $res->result->message_id ?? null;
        if ($msgId) $db->query("UPDATE `user` SET `captcha_msg_id`={$msgId} WHERE `from_id`='{$from_id}'");
    }
}
// ---------- Step 2: Callback Handler ----------
if ($isCallback && isset($data)) {
    if (preg_match('/^captcha_(.+)_(\d+)$/u', $data, $m)) {
        $fileId = $m[1];
        $user_answer = (int)$m[2]; // گزینه انتخاب شده توسط کاربر

        $q = $db->query("SELECT `captcha_answer`,`captcha_attempts`,`captcha_msg_id`,`captcha_photo_msg_id`,`captcha_audio_msg_id`
                         FROM `user` WHERE `from_id`='{$from_id}' LIMIT 1");

        $row = ($q && mysqli_num_rows($q)>0) ? mysqli_fetch_assoc($q) : null;

        $correct  = $row ? (int)$row['captcha_answer']   : null;
        $attempts = $row ? (int)$row['captcha_attempts'] : 0;
        $capMsgId = $row ? (int)$row['captcha_msg_id']   : null;
        $photoMsgId = $row ? (int)$row['captcha_photo_msg_id'] : null;
        $audioMsgId = $row ? (int)$row['captcha_audio_msg_id'] : null;

        $maxAttempts = 2;

        if ($correct !== null && $user_answer === $correct) {
            // ✅ پاسخ صحیح
            if ($capMsgId) { @deleteMessage($from_id, $capMsgId); }
            if ($photoMsgId) { @deleteMessage($from_id, $photoMsgId); }
            if ($audioMsgId) { @deleteMessage($from_id, $audioMsgId); }

            $db->query("UPDATE `user` 
                           SET `step`='none',
                               `captcha_answer`=NULL,
                               `captcha_attempts`=0,
                               `captcha_msg_id`=NULL,
                               `captcha_photo_msg_id`=NULL,
                               `captcha_audio_msg_id`=NULL
                     WHERE `from_id`='{$from_id}'");

            // نوتیف کشویی بالای صفحه
            if (!empty($callback_query_id)) {
                answercallbackquery($callback_query_id, "✅ پاسخ صحیح بود، فایل‌ها در حال ارسال هستند", false);
            }

            // بازگشت به روند اصلی → اینجا حتماً باید همون منطق send اجرا بشه
            send($from_id, null, $fileId, 'send');
            // null کردن getFile بعد از موفقیت (فرض بر موفقیت send)
            $db->query("UPDATE `user` SET `getFile`=NULL WHERE `from_id`='{$from_id}'");

        } else {
            // ❌ پاسخ اشتباه
            $attempts++;
            $db->query("UPDATE `user` SET `captcha_attempts`={$attempts} WHERE `from_id`='{$from_id}'");

            if ($attempts >= $maxAttempts) {
                if ($capMsgId) { @deleteMessage($from_id, $capMsgId); }
                if ($photoMsgId) { @deleteMessage($from_id, $photoMsgId); }
                if ($audioMsgId) { @deleteMessage($from_id, $audioMsgId); }

                $db->query("UPDATE `user` 
                               SET `step`='none',
                                   `captcha_answer`=NULL,
                                   `captcha_attempts`=0,
                                   `captcha_msg_id`=NULL,
                                   `captcha_photo_msg_id`=NULL,
                                   `captcha_audio_msg_id`=NULL
                         WHERE `from_id`='{$from_id}'");

                // ارسال پیام به جای پاپ‌آپ
                $retryKeyboard = json_encode([
                    'inline_keyboard' => [[
                        ['text' => 'امتحان مجدد', 'callback_data' => "retry_captcha_{$fileId}"]
                    ]]
                ], JSON_UNESCAPED_UNICODE);

                sendMessage($from_id, "⛔️ فرصت شما تمام شد. دوباره روی لینک بزنید.", "html", $retryKeyboard);

                // همچنان جواب کال‌بک برای جلوگیری از چرخش
                if (!empty($callback_query_id)) {
                    answercallbackquery($callback_query_id, "", false); // خالی برای جلوگیری از ارور
                }
            } else {
                // پاپ‌آپ اشتباه اول
                if (!empty($callback_query_id)) {
                    answercallbackquery($callback_query_id, "🛑 پاسخ اشتباه بود، شما یکبار دیگر فرصت دارید.", true);
                }
            }
        }
        exit;
    } elseif (preg_match('/^retry_captcha_(.+)$/', $data, $m)) {
        $fileId = $m[1];

        // حذف پیام شکست و دکمه
        @deleteMessage($from_id, $message_id);

        // شروع مجدد کپچا (بدون پیام واسط)
        sendCaptcha($from_id, $fileId);

        // جواب کال‌بک برای جلوگیری از چرخش
        if (!empty($callback_query_id)) {
            answercallbackquery($callback_query_id, "", false);
        }
        exit;
    }
}


// ---------- Step 3: Text Answer ----------
if (!$isCallback && $user['step']=='captcha' && isset($text)) {
    $id = $user['getFile'];
    $answer   = (string)$user['captcha_answer'];
    $attempts = isset($user['captcha_attempts']) ? (int)$user['captcha_attempts'] : 0;
    $capMsgId = isset($user['captcha_msg_id']) ? (int)$user['captcha_msg_id'] : null;
    $photoMsgId = isset($user['captcha_photo_msg_id']) ? (int)$user['captcha_photo_msg_id'] : null;
    $audioMsgId = isset($user['captcha_audio_msg_id']) ? (int)$user['captcha_audio_msg_id'] : null;
    $maxAttempts = 2;

    if (trim($text) === $answer) {
        if ($capMsgId) { @deleteMessage($from_id, $capMsgId); }
        if ($photoMsgId) { @deleteMessage($from_id, $photoMsgId); }
        if ($audioMsgId) { @deleteMessage($from_id, $audioMsgId); }

        $db->query("UPDATE `user` 
                       SET `step`='none',
                           `captcha_answer`=NULL,
                           `captcha_attempts`=0,
                           `captcha_msg_id`=NULL,
                           `captcha_photo_msg_id`=NULL,
                           `captcha_audio_msg_id`=NULL
                 WHERE `from_id`='{$from_id}'");

        // ✅ پیام ریز بالای صفحه (برای ورودی متنی نمی‌شه چون callback نیست)
        sendMessage($from_id, "✅ پاسخ صحیح بود، فایل‌ها در حال ارسال هستند.", "html");

        send($from_id, $message_id, $id, 'send');
        // null کردن getFile بعد از موفقیت (فرض بر موفقیت send)
        $db->query("UPDATE `user` SET `getFile`=NULL WHERE `from_id`='{$from_id}'");

    } else {
        $attempts++;
        $db->query("UPDATE `user` SET `captcha_attempts`={$attempts} WHERE `from_id`='{$from_id}'");

        if ($attempts >= $maxAttempts) {
            if ($capMsgId) { @deleteMessage($from_id, $capMsgId); }
            if ($photoMsgId) { @deleteMessage($from_id, $photoMsgId); }
            if ($audioMsgId) { @deleteMessage($from_id, $audioMsgId); }

            $db->query("UPDATE `user` 
                           SET `step`='none',
                               `captcha_answer`=NULL,
                               `captcha_attempts`=0,
                               `captcha_msg_id`=NULL,
                               `captcha_photo_msg_id`=NULL,
                               `captcha_audio_msg_id`=NULL
                     WHERE `from_id`='{$from_id}'");

            // ارسال پیام به جای پاپ‌آپ برای ورودی متنی
            $retryKeyboard = json_encode([
                'inline_keyboard' => [[
                    ['text' => 'امتحان مجدد', 'callback_data' => "retry_captcha_{$id}"]
                ]]
            ], JSON_UNESCAPED_UNICODE);

            sendMessage($from_id, "⛔️ فرصت شما برای کپچا تمام شد. دوباره روی لینک بزنید.", "html", $retryKeyboard);
        } else {
            sendMessage($from_id, "🛑 پاسخ اشتباه بود، شما یکبار دیگر فرصت دارید.", "html");
        }
    }
    exit;
}