<?php
// بارگذاری تنظیمات
require_once __DIR__ . '/config.php';

// اتصال به دیتابیس با PDO
try {
    $db = new PDO("mysql:host=localhost;dbname={$databaseName};charset=utf8mb4", $databaseUser, $databasePass);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    exit;
}

// تابع ارسال پیام
function sendMessage($chat_id, $text, $keyboard = null) {
    global $token;
    $url = "https://api.telegram.org/bot{$token}/sendMessage";
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    if ($keyboard) {
        $data['reply_markup'] = $keyboard;
    }
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_exec($ch);
    curl_close($ch);
}

// ساخت جدول warn_logs اگر نبود
$db->exec("
CREATE TABLE IF NOT EXISTS warn_logs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id BIGINT NOT NULL,
    warn_type VARCHAR(50) NOT NULL,
    warn_time DATETIME NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

// تابع گرفتن وضعیت اشتراک
function getSubscriptionStatus($db) {
    $stmt = $db->query("SELECT columnOne FROM settings WHERE type='subscription_status' LIMIT 1");
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    return $row ? $row['columnOne'] : 'on'; // پیش‌فرض روشن
}

// کیبورد کاربران بدون اشتراک (بسته به وضعیت روشن/خاموش)
function getNoSubKeyboard($db) {
    $status = getSubscriptionStatus($db);
    if ($status === 'off') {
        // وقتی اشتراک خاموشه → فقط پشتیبانی
        return json_encode([
            'keyboard' => [
                [['text' => "☎️ پشتیبانی کانال ایران بالیوود"], ['text' => "🤖 پشتیبانی ربات"]],
            ],
            'resize_keyboard' => true
        ], JSON_UNESCAPED_UNICODE);
    } else {
        // وقتی اشتراک روشنه → دکمه خرید + پشتیبانی
        return json_encode([
            'keyboard' => [
                [['text' => "💳 خرید اشتراک"]],
                [['text' => "🎁 خرید اشتراک هدیه برای دیگران"]],
                [['text' => "☎️ پشتیبانی کانال ایران بالیوود"], ['text' => "🤖 پشتیبانی ربات"]],
            ],
            'resize_keyboard' => true
        ], JSON_UNESCAPED_UNICODE);
    }
}

$subscription_status = getSubscriptionStatus($db);
$now = time();

$stmt = $db->query("
    SELECT user_id, end_date 
    FROM subscriptions 
    WHERE approved = 1
");

while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $end_time = strtotime($row['end_date']);
    $minutes_left = ($end_time - $now) / 60;

    // 🔹 اگر اشتراک روشن بود → هشدار کمتر از 1 روز
    if ($subscription_status === 'on' && $minutes_left > 0 && $minutes_left <= 1440) {
        $check_warn = $db->prepare("SELECT 1 FROM warn_logs WHERE user_id = ? AND warn_type = 'less_1day'");
        $check_warn->execute([$row['user_id']]);

        if (!$check_warn->fetch()) {
            sendMessage(
                $row['user_id'],
                "⏳ کاربر گرامی، اشتراک شما کمتر از یک روز دیگر به پایان می‌رسد!\nدر صورت تمایل می‌توانید از منوی زیر اشتراک خود را تمدید کنید."
            );
            $insert_warn = $db->prepare("INSERT INTO warn_logs (user_id, warn_type, warn_time) VALUES (?, 'less_1day', NOW())");
            $insert_warn->execute([$row['user_id']]);
        }
    }
// 🔹 پایان اشتراک → همیشه باید انجام شود
if ($minutes_left <= 0) {
    $keyboard = getNoSubKeyboard($db);

    if ($subscription_status === 'on') {
        // وقتی اشتراک روشن است
        $end_msg = "❌ اشتراک شما به پایان رسید.\nهمیشه در کمترین زمان ممکن می‌توانید از منوی پایین اشتراک تهیه کنید.";
    } else {
        // وقتی اشتراک خاموش است
        $end_msg = "❌ اشتراک شما به پایان رسید.";
    }

    sendMessage($row['user_id'], $end_msg, $keyboard);

    // حذف همه هشدارهای این کاربر
    $db->prepare("DELETE FROM warn_logs WHERE user_id = ?")->execute([$row['user_id']]);

    // حذف اشتراک از جدول subscriptions
    $db->prepare("DELETE FROM subscriptions WHERE user_id = ?")->execute([$row['user_id']]);
}

}
